/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExistsPredicate
extends Expression {
    private final Expression subquery;

    public ExistsPredicate(Expression subquery) {
        this(Optional.empty(), subquery);
    }

    public ExistsPredicate(NodeLocation location, Expression subquery) {
        this(Optional.of(location), subquery);
    }

    private ExistsPredicate(Optional<NodeLocation> location, Expression subquery) {
        super(location);
        Objects.requireNonNull(subquery, "subquery is null");
        this.subquery = subquery;
    }

    public Expression getSubquery() {
        return this.subquery;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExists(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.subquery);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExistsPredicate that = (ExistsPredicate)o;
        return Objects.equals(this.subquery, that.subquery);
    }

    @Override
    public int hashCode() {
        return this.subquery.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return ExistsPredicate.sameClass(this, other);
    }
}

