/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowTables
extends Statement {
    private final Optional<QualifiedName> schema;
    private final Optional<String> likePattern;
    private final Optional<String> escape;

    public ShowTables(Optional<QualifiedName> schema, Optional<String> likePattern, Optional<String> escape) {
        this(Optional.empty(), schema, likePattern, escape);
    }

    public ShowTables(NodeLocation location, Optional<QualifiedName> schema, Optional<String> likePattern, Optional<String> escape) {
        this(Optional.of(location), schema, likePattern, escape);
    }

    private ShowTables(Optional<NodeLocation> location, Optional<QualifiedName> schema, Optional<String> likePattern, Optional<String> escape) {
        super(location);
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(likePattern, "likePattern is null");
        Objects.requireNonNull(escape, "escape is null");
        this.schema = schema;
        this.likePattern = likePattern;
        this.escape = escape;
    }

    public Optional<QualifiedName> getSchema() {
        return this.schema;
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    public Optional<String> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowTables(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema, this.likePattern, this.escape);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowTables o = (ShowTables)obj;
        return Objects.equals(this.schema, o.schema) && Objects.equals(this.likePattern, o.likePattern) && Objects.equals(this.escape, o.escape);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("schema", this.schema).add("likePattern", this.likePattern).add("escape", this.escape).toString();
    }
}

