/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;

public class SchemaMappingRule {
    private final String remoteSchema;
    private final String mapping;

    @JsonCreator
    public SchemaMappingRule(@JsonProperty String remoteSchema, @JsonProperty String mapping) {
        this.remoteSchema = Objects.requireNonNull(remoteSchema, "remoteSchema is null");
        this.mapping = Objects.requireNonNull(mapping, "mapping is null");
        Preconditions.checkArgument((boolean)mapping.toLowerCase(Locale.ENGLISH).equals(mapping), (String)"Mapping is not lower cased: %s", (Object)mapping);
    }

    @JsonProperty
    public String getRemoteSchema() {
        return this.remoteSchema;
    }

    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaMappingRule that = (SchemaMappingRule)o;
        return this.remoteSchema.equals(that.remoteSchema) && this.mapping.equals(that.mapping);
    }

    public int hashCode() {
        return Objects.hash(this.remoteSchema, this.mapping);
    }
}

