/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ConstraintApplicationResult<T> {
    private final T handle;
    private final TupleDomain<ColumnHandle> remainingFilter;
    private final Optional<ConnectorExpression> remainingExpression;
    private final boolean precalculateStatistics;

    public ConstraintApplicationResult(T handle, TupleDomain<ColumnHandle> remainingFilter, boolean precalculateStatistics) {
        this(handle, remainingFilter, Optional.empty(), precalculateStatistics);
    }

    public ConstraintApplicationResult(T handle, TupleDomain<ColumnHandle> remainingFilter, ConnectorExpression remainingExpression, boolean precalculateStatistics) {
        this(handle, remainingFilter, Optional.of(remainingExpression), precalculateStatistics);
    }

    private ConstraintApplicationResult(T handle, TupleDomain<ColumnHandle> remainingFilter, Optional<ConnectorExpression> remainingExpression, boolean precalculateStatistics) {
        this.handle = Objects.requireNonNull(handle, "handle is null");
        this.remainingFilter = Objects.requireNonNull(remainingFilter, "remainingFilter is null");
        this.remainingExpression = Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        this.precalculateStatistics = precalculateStatistics;
    }

    public T getHandle() {
        return this.handle;
    }

    public TupleDomain<ColumnHandle> getRemainingFilter() {
        return this.remainingFilter;
    }

    public Optional<ConnectorExpression> getRemainingExpression() {
        return this.remainingExpression;
    }

    public boolean isPrecalculateStatistics() {
        return this.precalculateStatistics;
    }

    public <U> ConstraintApplicationResult<U> transform(Function<T, U> transformHandle) {
        return new ConstraintApplicationResult<U>(transformHandle.apply(this.handle), this.remainingFilter, this.remainingExpression, this.precalculateStatistics);
    }
}

