/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import io.trino.spi.Experimental;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.WindowFunctionSupplier;
import io.trino.spi.ptf.TableFunctionProcessorProvider;

@Experimental(eta="2023-03-31")
public interface FunctionProvider {
    default public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        throw new UnsupportedOperationException("%s does not provide scalar functions".formatted(this.getClass().getName()));
    }

    default public AggregationImplementation getAggregationImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        throw new UnsupportedOperationException("%s does not provide aggregation functions".formatted(this.getClass().getName()));
    }

    default public WindowFunctionSupplier getWindowFunctionSupplier(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        throw new UnsupportedOperationException("%s does not provide window functions".formatted(this.getClass().getName()));
    }

    default public TableFunctionProcessorProvider getTableFunctionProcessorProvider(SchemaFunctionName name) {
        throw new UnsupportedOperationException("%s does not provide table functions".formatted(this.getClass().getName()));
    }
}

