/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;

public final class Range {
    private final Type type;
    private final boolean lowInclusive;
    private final Optional<Object> lowValue;
    private final boolean highInclusive;
    private final Optional<Object> highValue;
    private final MethodHandle comparisonOperator;
    private final boolean isSingleValue;

    Range(Type type, boolean lowInclusive, Optional<Object> lowValue, boolean highInclusive, Optional<Object> highValue, MethodHandle comparisonOperator) {
        Objects.requireNonNull(type, "type is null");
        this.type = type;
        Objects.requireNonNull(lowValue, "lowValue is null");
        Objects.requireNonNull(highValue, "highValue is null");
        Objects.requireNonNull(comparisonOperator, "comparisonOperator is null");
        if (lowValue.isEmpty() && lowInclusive) {
            throw new IllegalArgumentException("low bound must be exclusive for low unbounded range");
        }
        if (highValue.isEmpty() && highInclusive) {
            throw new IllegalArgumentException("high bound must be exclusive for high unbounded range");
        }
        boolean isSingleValue = false;
        if (lowValue.isPresent() && highValue.isPresent()) {
            int compare = Range.compareValues(comparisonOperator, lowValue.get(), highValue.get());
            if (compare > 0) {
                throw new IllegalArgumentException("low must be less than or equal to high");
            }
            if (compare == 0) {
                if (!highInclusive || !lowInclusive) {
                    throw new IllegalArgumentException("invalid bounds for single value range");
                }
                isSingleValue = true;
            }
        }
        lowValue.ifPresent(value -> Range.verifyNotNan(type, value));
        highValue.ifPresent(value -> Range.verifyNotNan(type, value));
        this.lowInclusive = lowInclusive;
        this.lowValue = lowValue;
        this.highInclusive = highInclusive;
        this.highValue = highValue;
        this.comparisonOperator = comparisonOperator;
        this.isSingleValue = isSingleValue;
    }

    private static void verifyNotNan(Type type, Object value) {
        if (TypeUtils.isFloatingPointNaN(type, value)) {
            throw new IllegalArgumentException("cannot use NaN as range bound");
        }
    }

    static MethodHandle getComparisonOperator(Type type) {
        return Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL));
    }

    public static Range all(Type type) {
        return new Range(type, false, Optional.empty(), false, Optional.empty(), Range.getComparisonOperator(type));
    }

    public static Range greaterThan(Type type, Object low) {
        Objects.requireNonNull(low, "low is null");
        return new Range(type, false, Optional.of(low), false, Optional.empty(), Range.getComparisonOperator(type));
    }

    public static Range greaterThanOrEqual(Type type, Object low) {
        Objects.requireNonNull(low, "low is null");
        return new Range(type, true, Optional.of(low), false, Optional.empty(), Range.getComparisonOperator(type));
    }

    public static Range lessThan(Type type, Object high) {
        Objects.requireNonNull(high, "high is null");
        return new Range(type, false, Optional.empty(), false, Optional.of(high), Range.getComparisonOperator(type));
    }

    public static Range lessThanOrEqual(Type type, Object high) {
        Objects.requireNonNull(high, "high is null");
        return new Range(type, false, Optional.empty(), true, Optional.of(high), Range.getComparisonOperator(type));
    }

    public static Range equal(Type type, Object value) {
        Objects.requireNonNull(value, "value is null");
        Optional<Object> valueAsOptional = Optional.of(value);
        return new Range(type, true, valueAsOptional, true, valueAsOptional, Range.getComparisonOperator(type));
    }

    public static Range range(Type type, Object low, boolean lowInclusive, Object high, boolean highInclusive) {
        Objects.requireNonNull(low, "low is null");
        Objects.requireNonNull(high, "high is null");
        return new Range(type, lowInclusive, Optional.of(low), highInclusive, Optional.of(high), Range.getComparisonOperator(type));
    }

    public Type getType() {
        return this.type;
    }

    public boolean isLowInclusive() {
        return this.lowInclusive;
    }

    public boolean isLowUnbounded() {
        return this.lowValue.isEmpty();
    }

    public Object getLowBoundedValue() {
        return this.lowValue.orElseThrow(() -> new IllegalStateException("The range is low-unbounded"));
    }

    public Optional<Object> getLowValue() {
        return this.lowValue;
    }

    public boolean isHighInclusive() {
        return this.highInclusive;
    }

    public boolean isHighUnbounded() {
        return this.highValue.isEmpty();
    }

    public Object getHighBoundedValue() {
        return this.highValue.orElseThrow(() -> new IllegalStateException("The range is high-unbounded"));
    }

    public Optional<Object> getHighValue() {
        return this.highValue;
    }

    public boolean isSingleValue() {
        return this.isSingleValue;
    }

    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("Range does not have just a single value");
        }
        return this.lowValue.orElseThrow();
    }

    public boolean isAll() {
        return this.lowValue.isEmpty() && this.highValue.isEmpty();
    }

    public boolean contains(Range other) {
        this.checkTypeCompatibility(other);
        return this.compareLowBound(other) <= 0 && this.compareHighBound(other) >= 0;
    }

    public Range span(Range other) {
        this.checkTypeCompatibility(other);
        int compareLowBound = this.compareLowBound(other);
        int compareHighBound = this.compareHighBound(other);
        return new Range(this.type, compareLowBound <= 0 ? this.lowInclusive : other.lowInclusive, compareLowBound <= 0 ? this.lowValue : other.lowValue, compareHighBound >= 0 ? this.highInclusive : other.highInclusive, compareHighBound >= 0 ? this.highValue : other.highValue, this.comparisonOperator);
    }

    public Optional<Range> intersect(Range other) {
        this.checkTypeCompatibility(other);
        if (!this.overlaps(other)) {
            return Optional.empty();
        }
        int compareLowBound = this.compareLowBound(other);
        int compareHighBound = this.compareHighBound(other);
        return Optional.of(new Range(this.type, compareLowBound >= 0 ? this.lowInclusive : other.lowInclusive, compareLowBound >= 0 ? this.lowValue : other.lowValue, compareHighBound <= 0 ? this.highInclusive : other.highInclusive, compareHighBound <= 0 ? this.highValue : other.highValue, this.comparisonOperator));
    }

    public boolean overlaps(Range other) {
        this.checkTypeCompatibility(other);
        return !this.isFullyBefore(other) && !other.isFullyBefore(this);
    }

    Optional<Range> tryMergeWithNext(Range next) {
        boolean merge;
        if (this.compareLowBound(next) > 0) {
            throw new IllegalArgumentException("next before this");
        }
        if (this.isHighUnbounded()) {
            return Optional.of(this);
        }
        if (next.isLowUnbounded()) {
            merge = true;
        } else {
            int compare = Range.compareValues(this.comparisonOperator, this.highValue.orElseThrow(), next.lowValue.orElseThrow());
            boolean bl = merge = compare > 0 || compare == 0 && (this.highInclusive || next.lowInclusive);
        }
        if (merge) {
            int compareHighBound = this.compareHighBound(next);
            return Optional.of(new Range(this.type, this.lowInclusive, this.lowValue, compareHighBound <= 0 ? next.highInclusive : this.highInclusive, compareHighBound <= 0 ? next.highValue : this.highValue, this.comparisonOperator));
        }
        return Optional.empty();
    }

    private boolean isFullyBefore(Range other) {
        if (this.isHighUnbounded()) {
            return false;
        }
        if (other.isLowUnbounded()) {
            return false;
        }
        int compare = Range.compareValues(this.comparisonOperator, this.highValue.orElseThrow(), other.lowValue.orElseThrow());
        if (compare < 0) {
            return true;
        }
        if (compare == 0) {
            return !this.highInclusive || !other.lowInclusive;
        }
        return false;
    }

    private void checkTypeCompatibility(Range range) {
        if (!this.getType().equals(range.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Range types: %s vs %s", this.getType(), range.getType()));
        }
    }

    int compareLowBound(Range other) {
        if (this.isLowUnbounded() || other.isLowUnbounded()) {
            return Boolean.compare(!this.isLowUnbounded(), !other.isLowUnbounded());
        }
        int compare = Range.compareValues(this.comparisonOperator, this.lowValue.orElseThrow(), other.lowValue.orElseThrow());
        if (compare != 0) {
            return compare;
        }
        return Boolean.compare(!this.lowInclusive, !other.lowInclusive);
    }

    private int compareHighBound(Range other) {
        if (this.isHighUnbounded() || other.isHighUnbounded()) {
            return Boolean.compare(this.isHighUnbounded(), other.isHighUnbounded());
        }
        int compare = Range.compareValues(this.comparisonOperator, this.highValue.orElseThrow(), other.highValue.orElseThrow());
        if (compare != 0) {
            return compare;
        }
        return Boolean.compare(this.highInclusive, other.highInclusive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.lowInclusive == range.lowInclusive && this.highInclusive == range.highInclusive && this.type.equals(range.type) && this.valuesEqual(this.lowValue, range.lowValue) && this.valuesEqual(this.highValue, range.highValue);
    }

    private boolean valuesEqual(Optional<Object> a, Optional<Object> b) {
        if (a.isEmpty() || b.isEmpty()) {
            return a.isEmpty() == b.isEmpty();
        }
        return Range.compareValues(this.comparisonOperator, a.get(), b.get()) == 0;
    }

    private static int compareValues(MethodHandle comparisonOperator, Object left, Object right) {
        try {
            return (int)comparisonOperator.invoke(left, right);
        }
        catch (Throwable throwable) {
            throw Utils.handleThrowable(throwable);
        }
    }

    public int hashCode() {
        return Objects.hash(this.type, this.lowInclusive, this.lowValue, this.highInclusive, this.highValue);
    }

    public String toString() {
        return this.toString(ToStringSession.INSTANCE);
    }

    public String toString(ConnectorSession session) {
        Object lowObject = this.lowValue.map(value -> this.type.getObjectValue(session, Utils.nativeValueToBlock(this.type, value), 0)).orElse("<min>");
        if (this.isSingleValue()) {
            return String.format("[%s]", lowObject);
        }
        Object highObject = this.highValue.map(value -> this.type.getObjectValue(session, Utils.nativeValueToBlock(this.type, value), 0)).orElse("<max>");
        return String.format("%s%s, %s%s", this.lowInclusive ? "[" : "(", lowObject, highObject, this.highInclusive ? "]" : ")");
    }
}

