/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.Page;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorMergeSink;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorMergeSink
implements ConnectorMergeSink {
    private final ConnectorMergeSink delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorMergeSink(@ForClassLoaderSafe ConnectorMergeSink delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public void storeMergedRows(Page page) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.storeMergedRows(page);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.finish();
            return completableFuture;
        }
    }

    public void abort() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.abort();
        }
    }
}

