/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.ScoreMode;

public class MultiCollector
implements Collector {
    private final boolean cacheScores;
    private final Collector[] collectors;

    public static Collector wrap(Collector ... collectors) {
        return MultiCollector.wrap(Arrays.asList(collectors));
    }

    public static Collector wrap(Iterable<? extends Collector> collectors) {
        int n = 0;
        for (Collector collector : collectors) {
            if (collector == null) continue;
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("At least 1 collector must not be null");
        }
        if (n == 1) {
            Collector col = null;
            for (Collector collector : collectors) {
                if (collector == null) continue;
                col = collector;
                break;
            }
            return col;
        }
        Collector[] colls = new Collector[n];
        n = 0;
        for (Collector collector : collectors) {
            if (collector == null) continue;
            colls[n++] = collector;
        }
        return new MultiCollector(colls);
    }

    private MultiCollector(Collector ... collectors) {
        this.collectors = collectors;
        int numNeedsScores = 0;
        for (Collector collector : collectors) {
            if (!collector.scoreMode().needsScores()) continue;
            ++numNeedsScores;
        }
        this.cacheScores = numNeedsScores >= 2;
    }

    @Override
    public ScoreMode scoreMode() {
        ScoreMode scoreMode = null;
        for (Collector collector : this.collectors) {
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            return ScoreMode.COMPLETE;
        }
        return scoreMode;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        ArrayList<LeafCollector> leafCollectors = new ArrayList<LeafCollector>();
        for (Collector collector : this.collectors) {
            LeafCollector leafCollector;
            try {
                leafCollector = collector.getLeafCollector(context);
            }
            catch (CollectionTerminatedException e) {
                continue;
            }
            leafCollectors.add(leafCollector);
        }
        switch (leafCollectors.size()) {
            case 0: {
                throw new CollectionTerminatedException();
            }
            case 1: {
                return (LeafCollector)leafCollectors.get(0);
            }
        }
        return new MultiLeafCollector(leafCollectors, this.cacheScores);
    }

    private static class MultiLeafCollector
    implements LeafCollector {
        private final boolean cacheScores;
        private final LeafCollector[] collectors;
        private int numCollectors;

        private MultiLeafCollector(List<LeafCollector> collectors, boolean cacheScores) {
            this.collectors = collectors.toArray(new LeafCollector[collectors.size()]);
            this.cacheScores = cacheScores;
            this.numCollectors = this.collectors.length;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.cacheScores) {
                scorer = new ScoreCachingWrappingScorer(scorer);
            }
            scorer = new FilterScorable(scorer){

                @Override
                public void setMinCompetitiveScore(float minScore) {
                }
            };
            for (int i = 0; i < this.numCollectors; ++i) {
                LeafCollector c = this.collectors[i];
                c.setScorer(scorer);
            }
        }

        private void removeCollector(int i) {
            System.arraycopy(this.collectors, i + 1, this.collectors, i, this.numCollectors - i - 1);
            --this.numCollectors;
            this.collectors[this.numCollectors] = null;
        }

        @Override
        public void collect(int doc) throws IOException {
            LeafCollector[] collectors = this.collectors;
            int numCollectors = this.numCollectors;
            int i = 0;
            while (i < numCollectors) {
                LeafCollector collector = collectors[i];
                try {
                    collector.collect(doc);
                    ++i;
                }
                catch (CollectionTerminatedException e) {
                    this.removeCollector(i);
                    numCollectors = this.numCollectors;
                    if (numCollectors != 0) continue;
                    throw new CollectionTerminatedException();
                }
            }
        }
    }
}

