/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertTrue;

public class DbResourceGroupConfig {
    private String configUrl;
    private String user;
    private String password;
    private boolean exactMatchSelectorEnabled;
    private Duration maxRefreshInterval = new Duration(1.0, TimeUnit.HOURS);
    private Duration refreshInterval = new Duration(1.0, TimeUnit.SECONDS);

    public String getConfigDbUrl() {
        return this.configUrl;
    }

    @Config(value="resource-groups.config-db-url")
    public DbResourceGroupConfig setConfigDbUrl(String configUrl) {
        this.configUrl = configUrl;
        return this;
    }

    public String getConfigDbUser() {
        return this.user;
    }

    @Config(value="resource-groups.config-db-user")
    @ConfigDescription(value="Database user name")
    public DbResourceGroupConfig setConfigDbUser(String configUser) {
        this.user = configUser;
        return this;
    }

    public String getConfigDbPassword() {
        return this.password;
    }

    @ConfigSecuritySensitive
    @Config(value="resource-groups.config-db-password")
    @ConfigDescription(value="Database password")
    public DbResourceGroupConfig setConfigDbPassword(String configPassword) {
        this.password = configPassword;
        return this;
    }

    @MinDuration(value="10s")
    public @MinDuration(value="10s") Duration getMaxRefreshInterval() {
        return this.maxRefreshInterval;
    }

    @Config(value="resource-groups.max-refresh-interval")
    @ConfigDescription(value="Time period for which the cluster will continue to accept queries after refresh failures cause configuration to become stale")
    public DbResourceGroupConfig setMaxRefreshInterval(Duration maxRefreshInterval) {
        this.maxRefreshInterval = maxRefreshInterval;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    @Config(value="resource-groups.refresh-interval")
    @ConfigDescription(value="How often the cluster reloads from the database")
    public DbResourceGroupConfig setRefreshInterval(Duration refreshInterval) {
        this.refreshInterval = refreshInterval;
        return this;
    }

    public boolean getExactMatchSelectorEnabled() {
        return this.exactMatchSelectorEnabled;
    }

    @Config(value="resource-groups.exact-match-selector-enabled")
    public DbResourceGroupConfig setExactMatchSelectorEnabled(boolean exactMatchSelectorEnabled) {
        this.exactMatchSelectorEnabled = exactMatchSelectorEnabled;
        return this;
    }

    @AssertTrue(message="maxRefreshInterval must be greater than refreshInterval")
    public @AssertTrue(message="maxRefreshInterval must be greater than refreshInterval") boolean isRefreshIntervalValid() {
        return this.maxRefreshInterval.compareTo(this.refreshInterval) > 0;
    }
}

