/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.avro.AvroColumnDecoder;
import io.trino.decoder.avro.AvroDeserializer;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;

class GenericRecordRowDecoder
implements RowDecoder {
    private List<Map.Entry<DecoderColumnHandle, AvroColumnDecoder>> columnDecoders;
    private final AvroDeserializer<GenericRecord> deserializer;

    public GenericRecordRowDecoder(AvroDeserializer<GenericRecord> deserializer, Set<DecoderColumnHandle> columns) {
        this.deserializer = Objects.requireNonNull(deserializer, "deserializer is null");
        Objects.requireNonNull(columns, "columns is null");
        this.columnDecoders = (List)columns.stream().map(column -> new AbstractMap.SimpleImmutableEntry<DecoderColumnHandle, AvroColumnDecoder>((DecoderColumnHandle)column, new AvroColumnDecoder((DecoderColumnHandle)column))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data) {
        GenericRecord avroRecord = this.deserializer.deserialize(data);
        return Optional.of((Map)this.columnDecoders.stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((AvroColumnDecoder)entry.getValue()).decodeField(avroRecord))));
    }
}

