/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import java.util.Objects;

public class KuduColumnHandle
implements ColumnHandle {
    public static final String ROW_ID = "row_uuid";
    public static final int ROW_ID_POSITION = -1;
    public static final KuduColumnHandle ROW_ID_HANDLE = new KuduColumnHandle("row_uuid", -1, (Type)VarbinaryType.VARBINARY);
    private final String name;
    private final int ordinalPosition;
    private final Type type;

    @JsonCreator
    public KuduColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="type") Type type) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.ordinalPosition = ordinalPosition;
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.name, this.type);
    }

    public boolean isVirtualRowId() {
        return this.name.equals(ROW_ID);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinalPosition, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KuduColumnHandle other = (KuduColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.ordinalPosition, other.ordinalPosition) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("ordinalPosition", this.ordinalPosition).add("type", (Object)this.type).toString();
    }
}

