/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.kudu.KuduConnector;
import io.trino.plugin.kudu.KuduModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class KuduConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "kudu";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        Versions.checkSpiVersion((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new KuduModule(context.getTypeManager()), binder -> binder.bind(ClassLoader.class).toInstance((Object)KuduConnectorFactory.class.getClassLoader())});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(KuduConnector.class);
    }
}

