/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.plugin.kudu.KuduClientConfig;
import io.trino.plugin.kudu.KuduConnector;
import io.trino.plugin.kudu.KuduMetadata;
import io.trino.plugin.kudu.KuduNodePartitioningProvider;
import io.trino.plugin.kudu.KuduPageSinkProvider;
import io.trino.plugin.kudu.KuduPageSourceProvider;
import io.trino.plugin.kudu.KuduRecordSetProvider;
import io.trino.plugin.kudu.KuduSecurityModule;
import io.trino.plugin.kudu.KuduSessionProperties;
import io.trino.plugin.kudu.KuduSplitManager;
import io.trino.plugin.kudu.procedures.RangePartitionProcedures;
import io.trino.plugin.kudu.properties.KuduTableProperties;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.TypeManager;
import java.util.Objects;

public class KuduModule
extends AbstractConfigurationAwareModule {
    private final TypeManager typeManager;

    public KuduModule(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    protected void setup(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(KuduConnector.class).in(Scopes.SINGLETON);
        binder.bind(KuduMetadata.class).in(Scopes.SINGLETON);
        binder.bind(KuduTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(KuduSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(KuduPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(KuduPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(KuduSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).annotatedWith(ForClassLoaderSafe.class).to(KuduNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(ClassLoaderSafeNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(KuduRecordSetProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(KuduClientConfig.class);
        binder.bind(RangePartitionProcedures.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Procedure.class);
        this.install((Module)new KuduSecurityModule());
    }

    @ProvidesIntoSet
    Procedure getAddRangePartitionProcedure(RangePartitionProcedures procedures) {
        return procedures.getAddPartitionProcedure();
    }

    @ProvidesIntoSet
    Procedure getDropRangePartitionProcedure(RangePartitionProcedures procedures) {
        return procedures.getDropPartitionProcedure();
    }
}

