/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import io.trino.plugin.kudu.KuduBucketFunction;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduPartitioningHandle;
import io.trino.plugin.kudu.KuduSplit;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import javax.inject.Inject;

public class KuduNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final KuduClientSession clientSession;

    @Inject
    public KuduNodePartitioningProvider(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public Optional<ConnectorBucketNodeMap> getBucketNodeMapping(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        KuduPartitioningHandle handle = (KuduPartitioningHandle)partitioningHandle;
        return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((int)handle.getBucketCount()));
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((KuduSplit)value).getBucketNumber();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        KuduPartitioningHandle handle = (KuduPartitioningHandle)partitioningHandle;
        return new KuduBucketFunction(handle.getBucketColumnIndexes(), partitionChannelTypes, this.clientSession.openTable(new SchemaTableName(handle.getSchema(), handle.getTable())));
    }
}

