/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.inject.Inject;
import io.trino.plugin.kudu.KuduRecordSet;
import io.trino.plugin.kudu.KuduRecordSetProvider;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;

public class KuduPageSourceProvider
implements ConnectorPageSourceProvider {
    private final KuduRecordSetProvider recordSetProvider;

    @Inject
    public KuduPageSourceProvider(KuduRecordSetProvider recordSetProvider) {
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        KuduRecordSet recordSet = (KuduRecordSet)this.recordSetProvider.getRecordSet(transaction, session, split, table, columns);
        return new RecordPageSource((RecordSet)recordSet);
    }
}

