/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.mysql;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.trino.plugin.eventlistener.mysql.MysqlEventListener;
import io.trino.plugin.eventlistener.mysql.MysqlEventListenerConfig;
import io.trino.plugin.eventlistener.mysql.QueryDao;
import io.trino.spi.TrinoWarning;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.EventListenerFactory;
import io.trino.spi.eventlistener.QueryInputMetadata;
import io.trino.spi.eventlistener.QueryOutputMetadata;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class MysqlEventListenerFactory
implements EventListenerFactory {
    public String getName() {
        return "mysql";
    }

    public EventListener create(Map<String, String> config) {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MysqlDataSourceModule(), binder -> {
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec((TypeLiteral)new TypeLiteral<Set<String>>(){});
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, String.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(QueryInputMetadata.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryOutputMetadata.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(TrinoWarning.class);
            binder.bind(QueryDao.class).toProvider(QueryDaoProvider.class).in(Scopes.SINGLETON);
            binder.bind(MysqlEventListener.class).in(Scopes.SINGLETON);
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (EventListener)injector.getInstance(MysqlEventListener.class);
    }

    private static class MysqlDataSourceModule
    implements Module {
        private MysqlDataSourceModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(MysqlEventListenerConfig.class);
        }

        @Singleton
        @Provides
        public ConnectionFactory createConnectionFactory(MysqlEventListenerConfig config) {
            return () -> DriverManager.getConnection(config.getUrl());
        }

        @Singleton
        @Provides
        public static Jdbi createJdbi(ConnectionFactory connectionFactory) {
            return Jdbi.create((ConnectionFactory)connectionFactory).installPlugin((JdbiPlugin)new SqlObjectPlugin());
        }
    }

    private static class QueryDaoProvider
    implements Provider<QueryDao> {
        private final QueryDao dao;

        @Inject
        public QueryDaoProvider(Jdbi jdbi) {
            this.dao = (QueryDao)jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(QueryDao.class);
        }

        public QueryDao get() {
            return this.dao;
        }
    }
}

