/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.parquet.DiskRange;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.reader.ChunkedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.parquet.format.ColumnIndex;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.parquet.schema.PrimitiveType;

public class TrinoColumnIndexStore
implements ColumnIndexStore {
    private final ParquetDataSource dataSource;
    private final List<ColumnIndexMetadata> columnIndexReferences;
    private final List<ColumnIndexMetadata> offsetIndexReferences;
    @Nullable
    private Map<ColumnPath, org.apache.parquet.internal.column.columnindex.ColumnIndex> columnIndexStore;
    @Nullable
    private Map<ColumnPath, org.apache.parquet.internal.column.columnindex.OffsetIndex> offsetIndexStore;

    public TrinoColumnIndexStore(ParquetDataSource dataSource, BlockMetaData block, Set<ColumnPath> columnsRead, Set<ColumnPath> columnsFiltered) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        Objects.requireNonNull(block, "block is null");
        Objects.requireNonNull(columnsRead, "columnsRead is null");
        Objects.requireNonNull(columnsFiltered, "columnsFiltered is null");
        ImmutableList.Builder columnIndexBuilder = ImmutableList.builderWithExpectedSize((int)columnsFiltered.size());
        ImmutableList.Builder offsetIndexBuilder = ImmutableList.builderWithExpectedSize((int)columnsRead.size());
        for (ColumnChunkMetaData column : block.getColumns()) {
            ColumnPath path = column.getPath();
            if (column.getColumnIndexReference() != null && columnsFiltered.contains(path)) {
                columnIndexBuilder.add((Object)new ColumnIndexMetadata(column.getColumnIndexReference(), path, column.getPrimitiveType()));
            }
            if (column.getOffsetIndexReference() == null || !columnsRead.contains(path)) continue;
            offsetIndexBuilder.add((Object)new ColumnIndexMetadata(column.getOffsetIndexReference(), path, column.getPrimitiveType()));
        }
        this.columnIndexReferences = columnIndexBuilder.build();
        this.offsetIndexReferences = offsetIndexBuilder.build();
    }

    public org.apache.parquet.internal.column.columnindex.ColumnIndex getColumnIndex(ColumnPath column) {
        if (this.columnIndexStore == null) {
            this.columnIndexStore = TrinoColumnIndexStore.loadIndexes(this.dataSource, this.columnIndexReferences, (inputStream, columnMetadata) -> {
                try {
                    return ParquetMetadataConverter.fromParquetColumnIndex((PrimitiveType)columnMetadata.getPrimitiveType(), (ColumnIndex)Util.readColumnIndex((InputStream)inputStream));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this.columnIndexStore.get(column);
    }

    public org.apache.parquet.internal.column.columnindex.OffsetIndex getOffsetIndex(ColumnPath column) {
        if (this.offsetIndexStore == null) {
            this.offsetIndexStore = TrinoColumnIndexStore.loadIndexes(this.dataSource, this.offsetIndexReferences, (inputStream, columnMetadata) -> {
                try {
                    return ParquetMetadataConverter.fromParquetOffsetIndex((OffsetIndex)Util.readOffsetIndex((InputStream)inputStream));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this.offsetIndexStore.get(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Map<ColumnPath, T> loadIndexes(ParquetDataSource dataSource, List<ColumnIndexMetadata> indexMetadata, BiFunction<InputStream, ColumnIndexMetadata, T> deserializer) {
        ArrayListMultimap ranges = ArrayListMultimap.create((int)indexMetadata.size(), (int)1);
        for (ColumnIndexMetadata column2 : indexMetadata) {
            ranges.put((Object)column2.getPath(), (Object)column2.getDiskRange());
        }
        Map columnInputStreams = dataSource.planRead(ranges, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        try {
            Map map = (Map)indexMetadata.stream().collect(ImmutableMap.toImmutableMap(ColumnIndexMetadata::getPath, column -> deserializer.apply((InputStream)columnInputStreams.get(column.getPath()), (ColumnIndexMetadata)column)));
            return map;
        }
        finally {
            columnInputStreams.values().forEach(ChunkedInputStream::close);
        }
    }

    private static class ColumnIndexMetadata {
        private final DiskRange diskRange;
        private final ColumnPath path;
        private final PrimitiveType primitiveType;

        private ColumnIndexMetadata(IndexReference indexReference, ColumnPath path, PrimitiveType primitiveType) {
            Objects.requireNonNull(indexReference, "indexReference is null");
            this.diskRange = new DiskRange(indexReference.getOffset(), indexReference.getLength());
            this.path = Objects.requireNonNull(path, "path is null");
            this.primitiveType = Objects.requireNonNull(primitiveType, "primitiveType is null");
        }

        private DiskRange getDiskRange() {
            return this.diskRange;
        }

        private ColumnPath getPath() {
            return this.path;
        }

        private PrimitiveType getPrimitiveType() {
            return this.primitiveType;
        }
    }
}

