/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.repdef;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.trino.parquet.writer.repdef.RepLevelIterable;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class RepLevelIterables {
    private RepLevelIterables() {
    }

    public static RepLevelIterable of(Block block) {
        return new BlockRepLevel(block);
    }

    public static RepLevelIterable of(ColumnarArray columnarArray, int maxRepLevel) {
        return new ArrayRepLevel(columnarArray, maxRepLevel);
    }

    public static RepLevelIterable of(ColumnarMap columnarMap, int maxRepLevel) {
        return new MapRepLevel(columnarMap, maxRepLevel);
    }

    public static Iterator<Integer> getIterator(List<RepLevelIterable> iterables) {
        return new NestedRepLevelIterator(iterables);
    }

    private static RepLevelIterable.RepetitionLevel nullValue(int value) {
        return new RepLevelIterable.RepetitionLevel(value, true);
    }

    private static RepLevelIterable.RepetitionLevel nonNullValue(int value) {
        return new RepLevelIterable.RepetitionLevel(value, false);
    }

    static class BlockRepLevel
    implements RepLevelIterable {
        private final Block block;

        BlockRepLevel(Block block) {
            this.block = Objects.requireNonNull(block, "block is null");
        }

        @Override
        public RepLevelIterable.RepValueIterator getIterator() {
            return new RepLevelIterable.RepValueIterator(){
                private int position = -1;

                @Override
                boolean end() {
                    return true;
                }

                protected RepLevelIterable.RepetitionLevel computeNext() {
                    ++this.position;
                    if (this.position == block.getPositionCount()) {
                        return (RepLevelIterable.RepetitionLevel)this.endOfData();
                    }
                    if (block.isNull(this.position)) {
                        return RepLevelIterables.nullValue(this.getBase());
                    }
                    return RepLevelIterables.nonNullValue(this.getBase());
                }
            };
        }
    }

    static class ArrayRepLevel
    implements RepLevelIterable {
        private final ColumnarArray columnarArray;
        private final int maxRepValue;

        ArrayRepLevel(ColumnarArray columnarArray, int maxRepValue) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxRepValue = maxRepValue;
        }

        @Override
        public RepLevelIterable.RepValueIterator getIterator() {
            return new RepLevelIterable.RepValueIterator(){
                private int position = -1;
                private FixedValueIterator iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected RepLevelIterable.RepetitionLevel computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return (RepLevelIterable.RepetitionLevel)this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarArray.getPositionCount()) {
                        return (RepLevelIterable.RepetitionLevel)this.endOfData();
                    }
                    if (columnarArray.isNull(this.position)) {
                        return RepLevelIterables.nullValue(this.getBase());
                    }
                    int arrayLength = columnarArray.getLength(this.position);
                    if (arrayLength == 0) {
                        return RepLevelIterables.nullValue(this.getBase());
                    }
                    this.iterator = new FixedValueIterator(arrayLength, this.getBase(), maxRepValue);
                    return (RepLevelIterable.RepetitionLevel)this.iterator.next();
                }
            };
        }
    }

    static class MapRepLevel
    implements RepLevelIterable {
        private final ColumnarMap columnarArray;
        private final int maxRepValue;

        MapRepLevel(ColumnarMap columnarArray, int maxRepValue) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxRepValue = maxRepValue;
        }

        @Override
        public RepLevelIterable.RepValueIterator getIterator() {
            return new RepLevelIterable.RepValueIterator(){
                private int position = -1;
                private FixedValueIterator iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected RepLevelIterable.RepetitionLevel computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return (RepLevelIterable.RepetitionLevel)this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarArray.getPositionCount()) {
                        return (RepLevelIterable.RepetitionLevel)this.endOfData();
                    }
                    if (columnarArray.isNull(this.position)) {
                        return RepLevelIterables.nullValue(this.getBase());
                    }
                    int arrayLength = columnarArray.getEntryCount(this.position);
                    if (arrayLength == 0) {
                        return RepLevelIterables.nullValue(this.getBase());
                    }
                    this.iterator = new FixedValueIterator(arrayLength, this.getBase(), maxRepValue);
                    return (RepLevelIterable.RepetitionLevel)this.iterator.next();
                }
            };
        }
    }

    static class NestedRepLevelIterator
    extends AbstractIterator<Integer> {
        private final List<RepLevelIterable.RepValueIterator> repValueIteratorList;
        private int iteratorIndex;

        NestedRepLevelIterator(List<RepLevelIterable> repValueIteratorList) {
            this.repValueIteratorList = (List)repValueIteratorList.stream().map(RepLevelIterable::getIterator).collect(ImmutableList.toImmutableList());
        }

        protected Integer computeNext() {
            RepLevelIterable.RepValueIterator current = this.repValueIteratorList.get(this.iteratorIndex);
            while (this.iteratorIndex > 0 && current.end()) {
                current = this.repValueIteratorList.get(--this.iteratorIndex);
            }
            while (current.hasNext()) {
                RepLevelIterable.RepetitionLevel currentRepValue = (RepLevelIterable.RepetitionLevel)current.next();
                if (currentRepValue.isNull() || this.iteratorIndex == this.repValueIteratorList.size() - 1) {
                    return currentRepValue.value();
                }
                int lastValue = currentRepValue.value();
                current = this.repValueIteratorList.get(this.iteratorIndex + 1);
                current.setBase(lastValue);
                ++this.iteratorIndex;
            }
            Preconditions.checkState((boolean)this.repValueIteratorList.stream().noneMatch(AbstractIterator::hasNext));
            return (Integer)this.endOfData();
        }
    }

    static class FixedValueIterator
    extends AbstractIterator<RepLevelIterable.RepetitionLevel> {
        private final int length;
        private final int parentValue;
        private final int currentValue;
        private int position = -1;

        FixedValueIterator(int length, int parentValue, int currentValue) {
            this.length = length;
            this.parentValue = parentValue;
            this.currentValue = currentValue;
        }

        protected RepLevelIterable.RepetitionLevel computeNext() {
            ++this.position;
            if (this.position < this.length) {
                if (this.position == 0) {
                    return RepLevelIterables.nonNullValue(this.parentValue);
                }
                return RepLevelIterables.nonNullValue(this.currentValue);
            }
            return (RepLevelIterable.RepetitionLevel)this.endOfData();
        }
    }
}

