/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import io.airlift.discovery.server.Id;
import io.airlift.discovery.server.Node;
import io.airlift.discovery.server.Service;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class DynamicServiceAnnouncement {
    private final Id<Service> id;
    private final String type;
    private final Map<String, String> properties;

    @JsonCreator
    public DynamicServiceAnnouncement(@JsonProperty(value="id") Id<Service> id, @JsonProperty(value="type") String type, @JsonProperty(value="properties") Map<String, String> properties) {
        this.id = id;
        this.type = type;
        this.properties = properties != null ? ImmutableMap.copyOf(properties) : null;
    }

    @NotNull
    public Id<Service> getId() {
        return this.id;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicServiceAnnouncement that = (DynamicServiceAnnouncement)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceAnnouncement{id=" + this.id + ", type='" + this.type + "', properties=" + this.properties + "}";
    }

    public static Function<DynamicServiceAnnouncement, Service> toServiceWith(final Id<Node> nodeId, final String location, final String pool) {
        return new Function<DynamicServiceAnnouncement, Service>(){

            public Service apply(DynamicServiceAnnouncement announcement) {
                return new Service(announcement.getId(), nodeId, announcement.getType(), pool, location, announcement.getProperties());
            }
        };
    }
}

