/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.server.DiscoveryConfig;
import io.airlift.discovery.server.DiscoveryServiceSelector;
import io.airlift.discovery.server.DynamicAnnouncementResource;
import io.airlift.discovery.server.DynamicStore;
import io.airlift.discovery.server.ForDynamicStore;
import io.airlift.discovery.server.Id;
import io.airlift.discovery.server.ReplicatedDynamicStore;
import io.airlift.discovery.server.Service;
import io.airlift.discovery.server.ServiceResource;
import io.airlift.discovery.server.StaticStore;
import io.airlift.discovery.store.InMemoryStore;
import io.airlift.discovery.store.ReplicatedStoreModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import java.util.Set;

public class EmbeddedDiscoveryModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(DiscoveryConfig.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServiceResource.class);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("discovery");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Service.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(Service.class);
        binder.bind(ServiceSelector.class).to(DiscoveryServiceSelector.class);
        binder.bind(StaticStore.class).to(EmptyStaticStore.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(DynamicAnnouncementResource.class);
        binder.bind(DynamicStore.class).to(ReplicatedDynamicStore.class).in(Scopes.SINGLETON);
        binder.install((Module)new ReplicatedStoreModule("dynamic", ForDynamicStore.class, InMemoryStore.class));
    }

    private static class EmptyStaticStore
    implements StaticStore {
        private EmptyStaticStore() {
        }

        @Override
        public void put(Service service) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(Id<Service> id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Service> getAll() {
            return ImmutableSet.of();
        }

        @Override
        public Set<Service> get(String type) {
            return ImmutableSet.of();
        }

        @Override
        public Set<Service> get(String type, String pool) {
            return ImmutableSet.of();
        }
    }
}

