/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.store;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.airlift.discovery.store.Version;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Entry {
    private final byte[] key;
    private final byte[] value;
    private final Version version;
    private final long timestamp;
    private final Long maxAgeInMs;

    @JsonCreator
    public Entry(@JsonProperty(value="key") byte[] key, @JsonProperty(value="value") byte[] value, @JsonProperty(value="version") Version version, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="maxAgeInMs") Long maxAgeInMs) {
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        Preconditions.checkNotNull((Object)version, (Object)"version is null");
        Preconditions.checkArgument((maxAgeInMs == null || maxAgeInMs > 0L ? 1 : 0) != 0, (Object)"maxAgeInMs must be greater than 0");
        this.value = value;
        this.key = key;
        this.timestamp = timestamp;
        this.maxAgeInMs = maxAgeInMs;
        this.version = version;
    }

    @JsonProperty
    public byte[] getKey() {
        return this.key;
    }

    @JsonProperty
    public byte[] getValue() {
        return this.value;
    }

    @JsonProperty
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty
    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Long getMaxAgeInMs() {
        return this.maxAgeInMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entry entry = (Entry)o;
        if (this.timestamp != entry.timestamp) {
            return false;
        }
        if (!Arrays.equals(this.key, entry.key)) {
            return false;
        }
        if (!Objects.equals(this.maxAgeInMs, entry.maxAgeInMs)) {
            return false;
        }
        if (!Arrays.equals(this.value, entry.value)) {
            return false;
        }
        return this.version.equals(entry.version);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.key);
        result = 31 * result + (this.value != null ? Arrays.hashCode(this.value) : 0);
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.maxAgeInMs != null ? this.maxAgeInMs.hashCode() : 0);
        return result;
    }
}

