/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hudi.HudiMetadata;
import io.trino.plugin.hudi.HudiTransactionManager;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class HudiConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final HudiTransactionManager transactionManager;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final Set<SystemTable> systemTables;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> tableProperties;

    public HudiConnector(LifeCycleManager lifeCycleManager, HudiTransactionManager transactionManager, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, Set<SystemTable> systemTables, Set<SessionPropertiesProvider> sessionPropertiesProviders, List<PropertyMetadata<?>> tableProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.sessionProperties = (List)Objects.requireNonNull(sessionPropertiesProviders, "sessionPropertiesProviders is null").stream().flatMap(sessionPropertiesProvider -> sessionPropertiesProvider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
        this.tableProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableProperties, "tableProperties is null"));
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        HudiMetadata metadata = this.transactionManager.get(transactionHandle, session.getIdentity());
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)metadata, this.getClass().getClassLoader());
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.SERIALIZABLE, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle(true);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.transactionManager.put((ConnectorTransactionHandle)transaction);
        }
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        this.transactionManager.commit(transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        this.transactionManager.rollback(transaction);
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

