/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.split;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.util.AsyncQueue;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.partition.HudiPartitionInfo;
import io.trino.plugin.hudi.partition.HudiPartitionInfoLoader;
import io.trino.plugin.hudi.query.HudiDirectoryLister;
import io.trino.plugin.hudi.split.HudiSplitFactory;
import io.trino.plugin.hudi.split.HudiSplitWeightProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;

public class HudiBackgroundSplitLoader {
    private final ConnectorSession session;
    private final HudiDirectoryLister hudiDirectoryLister;
    private final AsyncQueue<ConnectorSplit> asyncQueue;
    private final ExecutorService executor;
    private final Consumer<Throwable> errorListener;
    private final HudiSplitFactory hudiSplitFactory;

    public HudiBackgroundSplitLoader(ConnectorSession session, HudiTableHandle tableHandle, HudiDirectoryLister hudiDirectoryLister, AsyncQueue<ConnectorSplit> asyncQueue, ExecutorService executor, HudiSplitWeightProvider hudiSplitWeightProvider, Consumer<Throwable> errorListener) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.hudiDirectoryLister = Objects.requireNonNull(hudiDirectoryLister, "hudiDirectoryLister is null");
        this.asyncQueue = Objects.requireNonNull(asyncQueue, "asyncQueue is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.errorListener = Objects.requireNonNull(errorListener, "errorListener is null");
        this.hudiSplitFactory = new HudiSplitFactory(tableHandle, hudiSplitWeightProvider);
    }

    public void start() {
        ListenableFuture partitionsFuture = Futures.submit(this::loadPartitions, (Executor)this.executor);
        this.hookErrorListener(partitionsFuture);
        ListenableFuture splitFutures = Futures.transform((ListenableFuture)partitionsFuture, partitions -> {
            List futures = partitions.stream().map(partition -> Futures.submit(() -> this.loadSplits((HudiPartitionInfo)partition), (Executor)this.executor)).peek(this::hookErrorListener).collect(Collectors.toList());
            Futures.whenAllComplete(futures).run(() -> this.asyncQueue.finish(), MoreExecutors.directExecutor());
            return null;
        }, (Executor)MoreExecutors.directExecutor());
        this.hookErrorListener(splitFutures);
    }

    private Collection<HudiPartitionInfo> loadPartitions() {
        HudiPartitionInfoLoader partitionInfoLoader = new HudiPartitionInfoLoader(this.session, this.hudiDirectoryLister);
        partitionInfoLoader.run();
        return partitionInfoLoader.getPartitionQueue();
    }

    private void loadSplits(HudiPartitionInfo partition) {
        List<HivePartitionKey> partitionKeys = partition.getHivePartitionKeys();
        List<FileStatus> partitionFiles = this.hudiDirectoryLister.listStatus(partition);
        partitionFiles.stream().flatMap(fileStatus -> this.hudiSplitFactory.createSplits(partitionKeys, (FileStatus)fileStatus)).map(arg_0 -> this.asyncQueue.offer(arg_0)).forEachOrdered(MoreFutures::getFutureValue);
    }

    private <T> void hookErrorListener(ListenableFuture<T> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
            }

            public void onFailure(Throwable t) {
                HudiBackgroundSplitLoader.this.errorListener.accept(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

