/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.redis.RedisConnectorConfig;
import io.trino.plugin.redis.RedisJedisManager;
import io.trino.plugin.redis.RedisSplit;
import io.trino.plugin.redis.RedisTableHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import redis.clients.jedis.Jedis;

public class RedisSplitManager
implements ConnectorSplitManager {
    private final Set<HostAddress> nodes;
    private final RedisJedisManager jedisManager;
    private static final long REDIS_MAX_SPLITS = 100L;
    private static final long REDIS_STRIDE_SPLITS = 100L;

    @Inject
    public RedisSplitManager(RedisConnectorConfig redisConnectorConfig, RedisJedisManager jedisManager) {
        Objects.requireNonNull(redisConnectorConfig, "redisConnectorConfig is null");
        this.nodes = ImmutableSet.copyOf(redisConnectorConfig.getNodes());
        this.jedisManager = Objects.requireNonNull(jedisManager, "jedisManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        long stride;
        RedisTableHandle redisTableHandle = (RedisTableHandle)table;
        ArrayList<HostAddress> nodes = new ArrayList<HostAddress>(this.nodes);
        Collections.shuffle(nodes);
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No Redis nodes available");
        ImmutableList.Builder builder = ImmutableList.builder();
        long numberOfKeys = 1L;
        if (redisTableHandle.getKeyDataFormat().equals("zset")) {
            try (Jedis jedis = this.jedisManager.getJedisPool((HostAddress)nodes.get(0)).getResource();){
                numberOfKeys = jedis.zcount(redisTableHandle.getKeyName(), "-inf", "+inf");
            }
        }
        if (numberOfKeys / (stride = 100L) > 100L) {
            stride = numberOfKeys / 100L;
        }
        for (long startIndex = 0L; startIndex < numberOfKeys; startIndex += stride) {
            long endIndex = startIndex + stride - 1L;
            if (endIndex >= numberOfKeys) {
                endIndex = -1L;
            }
            RedisSplit split = new RedisSplit(redisTableHandle.getSchemaName(), redisTableHandle.getTableName(), redisTableHandle.getKeyDataFormat(), redisTableHandle.getValueDataFormat(), redisTableHandle.getKeyName(), redisTableHandle.getConstraint(), startIndex, endIndex, nodes);
            builder.add((Object)split);
        }
        return new FixedSplitSource((Iterable)builder.build());
    }
}

