/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis.decoder.hash;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.plugin.redis.RedisFieldDecoder;
import io.trino.plugin.redis.decoder.RedisRowDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HashRedisRowDecoder
implements RedisRowDecoder {
    public static final String NAME = "hash";
    private final Map<DecoderColumnHandle, RedisFieldDecoder<String>> fieldDecoders;

    public HashRedisRowDecoder(Map<DecoderColumnHandle, RedisFieldDecoder<String>> fieldDecoders) {
        this.fieldDecoders = ImmutableMap.copyOf(fieldDecoders);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(Map<String, String> dataMap) {
        if (dataMap == null) {
            return Optional.of(Collections.emptyMap());
        }
        HashMap<DecoderColumnHandle, FieldValueProvider> decodedRow = new HashMap<DecoderColumnHandle, FieldValueProvider>();
        for (Map.Entry<DecoderColumnHandle, RedisFieldDecoder<String>> entry : this.fieldDecoders.entrySet()) {
            DecoderColumnHandle columnHandle = entry.getKey();
            String mapping = columnHandle.getMapping();
            Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for column handle %s!", (Object)columnHandle);
            String valueField = dataMap.get(mapping);
            RedisFieldDecoder<String> decoder = entry.getValue();
            decodedRow.put(columnHandle, decoder.decode(valueField, columnHandle));
        }
        return Optional.of(decodedRow);
    }

    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data) {
        throw new UnsupportedOperationException();
    }
}

