/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.base.Preconditions;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.filesystem.hdfs.HdfsInput;
import io.trino.filesystem.hdfs.HdfsTrinoInputStream;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class HdfsInputFile
implements TrinoInputFile {
    private final String path;
    private final HdfsEnvironment environment;
    private final HdfsContext context;
    private final Path file;
    private Long length;
    private FileStatus status;

    public HdfsInputFile(String path, Long length, HdfsEnvironment environment, HdfsContext context) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.file = HadoopPaths.hadoopPath(path);
        this.length = length;
        Preconditions.checkArgument((length == null || length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
    }

    public TrinoInput newInput() throws IOException {
        return new HdfsInput(this.openFile(), this);
    }

    public TrinoInputStream newStream() throws IOException {
        return new HdfsTrinoInputStream(this.openFile());
    }

    public long length() throws IOException {
        if (this.length == null) {
            this.length = this.lazyStatus().getLen();
        }
        return this.length;
    }

    public Instant lastModified() throws IOException {
        return Instant.ofEpochMilli(this.lazyStatus().getModificationTime());
    }

    public boolean exists() throws IOException {
        FileSystem fileSystem = this.environment.getFileSystem(this.context, this.file);
        return this.environment.doAs(this.context.getIdentity(), () -> fileSystem.exists(this.file));
    }

    public String location() {
        return this.path;
    }

    public String toString() {
        return this.location();
    }

    private FSDataInputStream openFile() throws IOException {
        FileSystem fileSystem = this.environment.getFileSystem(this.context, this.file);
        return this.environment.doAs(this.context.getIdentity(), () -> fileSystem.open(this.file));
    }

    private FileStatus lazyStatus() throws IOException {
        if (this.status == null) {
            FileSystem fileSystem = this.environment.getFileSystem(this.context, this.file);
            this.status = this.environment.doAs(this.context.getIdentity(), () -> fileSystem.getFileStatus(this.file));
        }
        return this.status;
    }
}

