/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.OpCode;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import java.util.List;
import java.util.Objects;

class ReturnBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final OpCode returnOpCode;

    ReturnBytecodeExpression(BytecodeExpression instance) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.returnOpCode = ReturnBytecodeExpression.returnOpCode(instance.getType());
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.returnOpCode);
    }

    @Override
    protected String formatOneLine() {
        return "return " + this.instance;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.instance);
    }

    private static OpCode returnOpCode(ParameterizedType componentType) {
        Class<?> primitiveType = componentType.getPrimitiveType();
        if (primitiveType != null) {
            if (primitiveType == Byte.TYPE || primitiveType == Boolean.TYPE || primitiveType == Character.TYPE || primitiveType == Short.TYPE || primitiveType == Integer.TYPE) {
                return OpCode.IRETURN;
            }
            if (primitiveType == Long.TYPE) {
                return OpCode.LRETURN;
            }
            if (primitiveType == Float.TYPE) {
                return OpCode.FRETURN;
            }
            if (primitiveType == Double.TYPE) {
                return OpCode.DRETURN;
            }
            if (primitiveType == Void.TYPE) {
                return OpCode.RETURN;
            }
            throw new IllegalArgumentException("Unsupported array type: " + primitiveType);
        }
        return OpCode.ARETURN;
    }
}

