/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.common.HiveTable;
import com.linkedin.coral.common.HiveViewTable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveDbSchema
implements Schema {
    public static final String DEFAULT_DB = "default";
    private final HiveMetastoreClient msc;
    private final String dbName;

    HiveDbSchema(@Nonnull HiveMetastoreClient msc, @Nonnull String dbName) {
        Preconditions.checkNotNull((Object)msc);
        Preconditions.checkNotNull((Object)dbName);
        this.msc = msc;
        this.dbName = dbName;
    }

    public org.apache.calcite.schema.Table getTable(String name) {
        Table table = this.msc.getTable(this.dbName, name);
        if (table == null) {
            return null;
        }
        TableType tableType = Enum.valueOf(TableType.class, table.getTableType());
        switch (tableType) {
            case VIRTUAL_VIEW: {
                return new HiveViewTable(table, (List<String>)ImmutableList.of((Object)"hive", (Object)this.dbName));
            }
        }
        return new HiveTable(table);
    }

    public Set<String> getTableNames() {
        return ImmutableSet.copyOf(this.msc.getAllTables(this.dbName));
    }

    public RelProtoDataType getType(String s) {
        return null;
    }

    public Set<String> getTypeNames() {
        return null;
    }

    public Collection<Function> getFunctions(String name) {
        return ImmutableList.of();
    }

    public Set<String> getFunctionNames() {
        return ImmutableSet.of();
    }

    public Schema getSubSchema(String name) {
        return null;
    }

    public Set<String> getSubSchemaNames() {
        return ImmutableSet.of();
    }

    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return null;
    }

    public boolean isMutable() {
        return true;
    }

    public Schema snapshot(SchemaVersion schemaVersion) {
        return this;
    }
}

