/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.DoubleType;
import java.util.Optional;

public class ImplementStddevPop
implements AggregateFunctionRule<JdbcExpression, String> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"stddev_pop")).with(AggregateFunctionPatterns.singleArgument().matching(AggregateFunctionPatterns.variable().with(AggregateFunctionPatterns.expressionType().matching(DoubleType.class::isInstance)).capturedAs(ARGUMENT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<String> context) {
        Variable argument = (Variable)captures.get(ARGUMENT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(argument.getName());
        Verify.verify((aggregateFunction.getOutputType() == columnHandle.getColumnType() ? 1 : 0) != 0);
        return Optional.of(new JdbcExpression(String.format("stddev_pop(%s)", context.rewriteExpression((ConnectorExpression)argument).orElseThrow()), columnHandle.getJdbcTypeHandle()));
    }
}

