/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseRecordTransformer;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.format.ClickHouseSimpleRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClickHouseSimpleResponse
implements ClickHouseResponse {
    private static final long serialVersionUID = 6883452584393840649L;
    private final List<ClickHouseColumn> columns;
    private final List<ClickHouseRecord> records;
    private final ClickHouseResponseSummary summary;
    private volatile boolean closed;

    public static ClickHouseResponse of(ClickHouseConfig config, List<ClickHouseColumn> columns, Object[][] values) {
        return ClickHouseSimpleResponse.of(config, columns, values, null);
    }

    public static ClickHouseResponse of(ClickHouseConfig config, List<ClickHouseColumn> columns, Object[][] values, ClickHouseResponseSummary summary) {
        if (columns == null || columns.isEmpty()) {
            return ClickHouseResponse.EMPTY;
        }
        int size = columns.size();
        int len = values != null ? values.length : 0;
        ClickHouseValue[][] wrappedValues = new ClickHouseValue[len][];
        if (len > 0) {
            int i;
            ClickHouseValue[] templates = new ClickHouseValue[size];
            for (i = 0; i < size; ++i) {
                templates[i] = columns.get(i).newValue(config);
            }
            for (i = 0; i < len; ++i) {
                Object[] input = values[i];
                int count = input != null ? input.length : 0;
                ClickHouseValue[] v = new ClickHouseValue[size];
                for (int j = 0; j < size; ++j) {
                    v[j] = templates[j].copy().update(j < count ? input[j] : null);
                }
                wrappedValues[i] = v;
            }
        }
        return new ClickHouseSimpleResponse(columns, wrappedValues, summary);
    }

    public static ClickHouseResponse of(ClickHouseResponse response) {
        return ClickHouseSimpleResponse.of(response, null);
    }

    public static ClickHouseResponse of(ClickHouseResponse response, ClickHouseRecordTransformer func) {
        if (response == null) {
            return EMPTY;
        }
        if (response instanceof ClickHouseSimpleResponse) {
            return response;
        }
        List<ClickHouseColumn> columns = response.getColumns();
        int size = columns.size();
        LinkedList<ClickHouseRecord> records = new LinkedList<ClickHouseRecord>();
        int rowIndex = 0;
        for (ClickHouseRecord r : response.records()) {
            ClickHouseValue[] values = new ClickHouseValue[size];
            for (int i = 0; i < size; ++i) {
                values[i] = r.getValue(i).copy();
            }
            ClickHouseRecord rec = ClickHouseSimpleRecord.of(columns, values);
            if (func != null) {
                func.update(rowIndex, rec);
            }
            records.add(rec);
        }
        return new ClickHouseSimpleResponse(response.getColumns(), records, response.getSummary());
    }

    protected ClickHouseSimpleResponse(List<ClickHouseColumn> columns, List<ClickHouseRecord> records, ClickHouseResponseSummary summary) {
        this.columns = columns;
        this.records = Collections.unmodifiableList(records);
        this.summary = summary != null ? summary : ClickHouseResponseSummary.EMPTY;
    }

    protected ClickHouseSimpleResponse(List<ClickHouseColumn> columns, ClickHouseValue[][] values, ClickHouseResponseSummary summary) {
        this.columns = columns;
        int len = values.length;
        ArrayList<ClickHouseRecord> list = new ArrayList<ClickHouseRecord>(len);
        for (int i = 0; i < len; ++i) {
            list.add(ClickHouseSimpleRecord.of(columns, values[i]));
        }
        this.records = Collections.unmodifiableList(list);
        this.summary = summary != null ? summary : ClickHouseResponseSummary.EMPTY;
    }

    @Override
    public List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    @Override
    public ClickHouseResponseSummary getSummary() {
        return this.summary;
    }

    @Override
    public ClickHouseInputStream getInputStream() {
        throw new UnsupportedOperationException("An in-memory response does not have input stream");
    }

    @Override
    public Iterable<ClickHouseRecord> records() {
        return this.records;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

