/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.apache.commons.compress.harmony.unpack200.bytecode;

import com.clickhouse.client.internal.apache.commons.compress.harmony.unpack200.bytecode.AnnotationsAttribute;
import com.clickhouse.client.internal.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import com.clickhouse.client.internal.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import com.clickhouse.client.internal.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RuntimeVisibleorInvisibleAnnotationsAttribute
extends AnnotationsAttribute {
    private final int num_annotations;
    private final AnnotationsAttribute.Annotation[] annotations;

    public RuntimeVisibleorInvisibleAnnotationsAttribute(CPUTF8 name, AnnotationsAttribute.Annotation[] annotations) {
        super(name);
        this.num_annotations = annotations.length;
        this.annotations = annotations;
    }

    @Override
    protected int getLength() {
        int length = 2;
        for (int i = 0; i < this.num_annotations; ++i) {
            length += this.annotations[i].getLength();
        }
        return length;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        for (AnnotationsAttribute.Annotation annotation : this.annotations) {
            annotation.resolve(pool);
        }
    }

    @Override
    protected void writeBody(DataOutputStream dos) throws IOException {
        int size = dos.size();
        dos.writeShort(this.num_annotations);
        for (int i = 0; i < this.num_annotations; ++i) {
            this.annotations[i].writeBody(dos);
        }
        if (dos.size() - size != this.getLength()) {
            throw new Error();
        }
    }

    @Override
    public String toString() {
        return this.attributeName.underlyingString() + ": " + this.num_annotations + " annotations";
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        ArrayList<Object> nested = new ArrayList<Object>();
        nested.add(this.attributeName);
        for (AnnotationsAttribute.Annotation annotation : this.annotations) {
            nested.addAll(annotation.getClassFileEntries());
        }
        return nested.toArray(ClassFileEntry.NONE);
    }
}

