/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka;

import io.airlift.units.DataSize;
import io.trino.plugin.kafka.KafkaConfig;
import io.trino.plugin.kafka.KafkaConsumerFactory;
import io.trino.plugin.kafka.utils.PropertiesUtils;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSession;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

public class DefaultKafkaConsumerFactory
implements KafkaConsumerFactory {
    private final Set<HostAddress> nodes;
    private final DataSize kafkaBufferSize;
    private final Map<String, String> configurationProperties;

    @Inject
    public DefaultKafkaConsumerFactory(KafkaConfig kafkaConfig) throws Exception {
        this.nodes = kafkaConfig.getNodes();
        this.kafkaBufferSize = kafkaConfig.getKafkaBufferSize();
        this.configurationProperties = PropertiesUtils.readProperties(kafkaConfig.getResourceConfigFiles());
    }

    @Override
    public Properties configure(ConnectorSession session) {
        Properties properties = new Properties();
        properties.putAll(this.configurationProperties);
        properties.setProperty("bootstrap.servers", this.nodes.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
        properties.setProperty("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.setProperty("enable.auto.commit", Boolean.toString(false));
        properties.setProperty("receive.buffer.bytes", Long.toString(this.kafkaBufferSize.toBytes()));
        return properties;
    }
}

