/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.encoder;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import io.trino.plugin.kafka.encoder.DispatchingRowEncoderFactory;
import io.trino.plugin.kafka.encoder.RowEncoderFactory;
import io.trino.plugin.kafka.encoder.avro.AvroEncoderModule;
import io.trino.plugin.kafka.encoder.csv.CsvRowEncoderFactory;
import io.trino.plugin.kafka.encoder.json.JsonRowEncoderFactory;
import io.trino.plugin.kafka.encoder.protobuf.ProtobufEncoderModule;
import io.trino.plugin.kafka.encoder.raw.RawRowEncoderFactory;

public class EncoderModule
implements Module {
    public void configure(Binder binder) {
        MapBinder<String, RowEncoderFactory> encoderFactoriesByName = EncoderModule.encoderFactory(binder);
        encoderFactoriesByName.addBinding((Object)"csv").to(CsvRowEncoderFactory.class).in(Scopes.SINGLETON);
        encoderFactoriesByName.addBinding((Object)"raw").to(RawRowEncoderFactory.class).in(Scopes.SINGLETON);
        encoderFactoriesByName.addBinding((Object)"json").to(JsonRowEncoderFactory.class).in(Scopes.SINGLETON);
        binder.install((Module)new AvroEncoderModule());
        binder.install((Module)new ProtobufEncoderModule());
        binder.bind(DispatchingRowEncoderFactory.class).in(Scopes.SINGLETON);
    }

    public static MapBinder<String, RowEncoderFactory> encoderFactory(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, String.class, RowEncoderFactory.class);
    }
}

