/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.base.Preconditions;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.trino.plugin.kafka.schema.AbstractContentSchemaReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class AvroConfluentContentSchemaReader
extends AbstractContentSchemaReader {
    private final SchemaRegistryClient schemaRegistryClient;

    @Inject
    public AvroConfluentContentSchemaReader(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient is null");
    }

    @Override
    protected Optional<String> readSchema(Optional<String> dataSchemaLocation, Optional<String> subject) {
        if (subject.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkState((boolean)dataSchemaLocation.isEmpty(), (Object)"Unexpected parameter: dataSchemaLocation");
        try {
            SchemaMetadata schemaMetadata = this.schemaRegistryClient.getLatestSchemaMetadata(subject.get());
            ParsedSchema schema = this.schemaRegistryClient.getSchemaBySubjectAndId(subject.get(), schemaMetadata.getId());
            return Optional.ofNullable(schema.rawSchema()).map(Object::toString);
        }
        catch (RestClientException | IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Could not resolve schema for the '%s' subject", subject.get()), e);
        }
    }
}

