/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kafka.schema.confluent;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import io.trino.plugin.kafka.schema.confluent.AvroSchemaConverter;
import io.trino.spi.HostAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

public class ConfluentSchemaRegistryConfig {
    private Set<HostAddress> confluentSchemaRegistryUrls;
    private int confluentSchemaRegistryClientCacheSize = 1000;
    private AvroSchemaConverter.EmptyFieldStrategy emptyFieldStrategy = AvroSchemaConverter.EmptyFieldStrategy.IGNORE;
    private Duration confluentSubjectsCacheRefreshInterval = new Duration(1.0, TimeUnit.SECONDS);

    @Size(min=1)
    public @Size(min=1) Set<HostAddress> getConfluentSchemaRegistryUrls() {
        return this.confluentSchemaRegistryUrls;
    }

    @Config(value="kafka.confluent-schema-registry-url")
    @ConfigDescription(value="The url of the Confluent Schema Registry")
    public ConfluentSchemaRegistryConfig setConfluentSchemaRegistryUrls(String confluentSchemaRegistryUrls) {
        this.confluentSchemaRegistryUrls = confluentSchemaRegistryUrls == null ? null : ConfluentSchemaRegistryConfig.parseNodes(confluentSchemaRegistryUrls);
        return this;
    }

    @Min(value=1L)
    @Max(value=2000L)
    public @Min(value=1L) @Max(value=2000L) int getConfluentSchemaRegistryClientCacheSize() {
        return this.confluentSchemaRegistryClientCacheSize;
    }

    @Config(value="kafka.confluent-schema-registry-client-cache-size")
    @ConfigDescription(value="The maximum number of subjects that can be stored in the Confluent Schema Registry client cache")
    public ConfluentSchemaRegistryConfig setConfluentSchemaRegistryClientCacheSize(int confluentSchemaRegistryClientCacheSize) {
        this.confluentSchemaRegistryClientCacheSize = confluentSchemaRegistryClientCacheSize;
        return this;
    }

    public AvroSchemaConverter.EmptyFieldStrategy getEmptyFieldStrategy() {
        return this.emptyFieldStrategy;
    }

    @Config(value="kafka.empty-field-strategy")
    @ConfigDescription(value="How to handle struct types with no fields: ignore, add a boolean field named 'dummy' or fail the query")
    public ConfluentSchemaRegistryConfig setEmptyFieldStrategy(AvroSchemaConverter.EmptyFieldStrategy emptyFieldStrategy) {
        this.emptyFieldStrategy = emptyFieldStrategy;
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="30s")
    public @MinDuration(value="1ms") @MaxDuration(value="30s") Duration getConfluentSubjectsCacheRefreshInterval() {
        return this.confluentSubjectsCacheRefreshInterval;
    }

    @Config(value="kafka.confluent-subjects-cache-refresh-interval")
    @ConfigDescription(value="The interval that the topic to subjects cache will be refreshed")
    public ConfluentSchemaRegistryConfig setConfluentSubjectsCacheRefreshInterval(Duration confluentSubjectsCacheRefreshInterval) {
        this.confluentSubjectsCacheRefreshInterval = confluentSubjectsCacheRefreshInterval;
        return this;
    }

    private static ImmutableSet<HostAddress> parseNodes(String nodes) {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        return (ImmutableSet)Streams.stream((Iterable)splitter.split((CharSequence)nodes)).map(ConfluentSchemaRegistryConfig::toHostAddress).collect(ImmutableSet.toImmutableSet());
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value);
    }
}

