/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.ReflectionUtilsApi;
import java.lang.invoke.MethodHandles;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ReflectionUtils
implements ReflectionUtilsApi {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Module CORE_MODULE = ReflectionUtils.class.getModule();

    @Override
    public MethodHandles.Lookup getLookupToUse(Class<?> targetClass) throws Throwable {
        Module responseModule = targetClass.getModule();
        if (!responseModule.isNamed()) {
            CORE_MODULE.addReads(responseModule);
            return MethodHandles.privateLookupIn(targetClass, LOOKUP);
        }
        if (responseModule == CORE_MODULE) {
            return LOOKUP;
        }
        if (responseModule.isOpen(targetClass.getPackageName()) || responseModule.isOpen(targetClass.getPackageName(), CORE_MODULE)) {
            CORE_MODULE.addReads(responseModule);
            return MethodHandles.privateLookupIn(targetClass, LOOKUP);
        }
        return MethodHandles.publicLookup();
    }

    @Override
    public int getJavaImplementationMajorVersion() {
        return 9;
    }

    ReflectionUtils() {
    }
}

