/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.type.Category;
import io.trino.plugin.hive.type.MapTypeInfo;
import io.trino.plugin.hive.type.PrimitiveCategory;
import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public enum HiveStorageFormat {
    ORC("org.apache.hadoop.hive.ql.io.orc.OrcSerde", "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat", DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    PARQUET("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    AVRO("org.apache.hadoop.hive.serde2.avro.AvroSerDe", "org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat", "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat", DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    RCBINARY("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe", "org.apache.hadoop.hive.ql.io.RCFileInputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    RCTEXT("org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe", "org.apache.hadoop.hive.ql.io.RCFileInputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    SEQUENCEFILE("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", "org.apache.hadoop.mapred.SequenceFileInputFormat", "org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    JSON("org.apache.hive.hcatalog.data.JsonSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    TEXTFILE("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    CSV("org.apache.hadoop.hive.serde2.OpenCSVSerde", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)),
    REGEX("org.apache.hadoop.hive.serde2.RegexSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE));

    private final String serde;
    private final String inputFormat;
    private final String outputFormat;
    private final DataSize estimatedWriterMemoryUsage;
    private static final Map<SerdeAndInputFormat, HiveStorageFormat> HIVE_STORAGE_FORMAT_FROM_STORAGE_FORMAT;

    private HiveStorageFormat(String serde, String inputFormat, String outputFormat, DataSize estimatedWriterMemoryUsage) {
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.estimatedWriterMemoryUsage = Objects.requireNonNull(estimatedWriterMemoryUsage, "estimatedWriterMemoryUsage is null");
    }

    public String getSerde() {
        return this.serde;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public DataSize getEstimatedWriterMemoryUsage() {
        return this.estimatedWriterMemoryUsage;
    }

    public void validateColumns(List<HiveColumnHandle> handles) {
        if (this == AVRO) {
            for (HiveColumnHandle handle : handles) {
                if (handle.isPartitionKey()) continue;
                HiveStorageFormat.validateAvroType(handle.getHiveType().getTypeInfo(), handle.getName());
            }
        }
    }

    private static void validateAvroType(TypeInfo type, String columnName) {
        if (type.getCategory() == Category.MAP) {
            TypeInfo keyType = HiveStorageFormat.mapTypeInfo(type).getMapKeyTypeInfo();
            if (keyType.getCategory() != Category.PRIMITIVE || HiveStorageFormat.primitiveTypeInfo(keyType).getPrimitiveCategory() != PrimitiveCategory.STRING) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' has a non-varchar map key, which is not supported by Avro", columnName));
            }
        } else if (type.getCategory() == Category.PRIMITIVE) {
            PrimitiveCategory primitive = HiveStorageFormat.primitiveTypeInfo(type).getPrimitiveCategory();
            if (primitive == PrimitiveCategory.BYTE) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' is tinyint, which is not supported by Avro. Use integer instead.", columnName));
            }
            if (primitive == PrimitiveCategory.SHORT) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column '%s' is smallint, which is not supported by Avro. Use integer instead.", columnName));
            }
        }
    }

    public static Optional<HiveStorageFormat> getHiveStorageFormat(StorageFormat storageFormat) {
        return Optional.ofNullable(HIVE_STORAGE_FORMAT_FROM_STORAGE_FORMAT.get(new SerdeAndInputFormat(storageFormat.getSerde(), storageFormat.getInputFormat())));
    }

    private static PrimitiveTypeInfo primitiveTypeInfo(TypeInfo typeInfo) {
        return (PrimitiveTypeInfo)typeInfo;
    }

    private static MapTypeInfo mapTypeInfo(TypeInfo typeInfo) {
        return (MapTypeInfo)typeInfo;
    }

    static {
        HIVE_STORAGE_FORMAT_FROM_STORAGE_FORMAT = (Map)Arrays.stream(HiveStorageFormat.values()).collect(ImmutableMap.toImmutableMap(format -> new SerdeAndInputFormat(format.getSerde(), format.getInputFormat()), (Function)Functions.identity()));
    }

    private static final class SerdeAndInputFormat {
        private final String serde;
        private final String inputFormat;

        public SerdeAndInputFormat(String serde, String inputFormat) {
            this.serde = serde;
            this.inputFormat = inputFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerdeAndInputFormat that = (SerdeAndInputFormat)o;
            return this.serde.equals(that.serde) && this.inputFormat.equals(that.inputFormat);
        }

        public int hashCode() {
            return Objects.hash(this.serde, this.inputFormat);
        }
    }
}

