/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.hadoop.fs.Path;

public class LocationHandle {
    private final Path targetPath;
    private final Path writePath;
    private final WriteMode writeMode;

    public LocationHandle(Path targetPath, Path writePath, WriteMode writeMode) {
        if (writeMode.isWritePathSameAsTargetPath() && !targetPath.equals((Object)writePath)) {
            throw new IllegalArgumentException(String.format("targetPath is expected to be same as writePath for writeMode %s", new Object[]{writeMode}));
        }
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.writeMode = Objects.requireNonNull(writeMode, "writeMode is null");
    }

    @JsonCreator
    public LocationHandle(@JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="writePath") String writePath, @JsonProperty(value="writeMode") WriteMode writeMode) {
        this(new Path(Objects.requireNonNull(targetPath, "targetPath is null")), new Path(Objects.requireNonNull(writePath, "writePath is null")), writeMode);
    }

    Path getTargetPath() {
        return this.targetPath;
    }

    Path getWritePath() {
        return this.writePath;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    @JsonProperty(value="targetPath")
    public String getJsonSerializableTargetPath() {
        return this.targetPath.toString();
    }

    @JsonProperty(value="writePath")
    public String getJsonSerializableWritePath() {
        return this.writePath.toString();
    }

    @JsonProperty(value="writeMode")
    public WriteMode getJsonSerializableWriteMode() {
        return this.writeMode;
    }

    public static enum WriteMode {
        STAGE_AND_MOVE_TO_TARGET_DIRECTORY(false),
        DIRECT_TO_TARGET_NEW_DIRECTORY(true),
        DIRECT_TO_TARGET_EXISTING_DIRECTORY(true);

        private final boolean writePathSameAsTargetPath;

        private WriteMode(boolean writePathSameAsTargetPath) {
            this.writePathSameAsTargetPath = writePathSameAsTargetPath;
        }

        public boolean isWritePathSameAsTargetPath() {
            return this.writePathSameAsTargetPath;
        }
    }
}

