/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveTableProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.aws.athena.PartitionProjection;
import io.trino.plugin.hive.aws.athena.PartitionProjectionProperties;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.plugin.hive.aws.athena.projection.ProjectionFactory;
import io.trino.plugin.hive.aws.athena.projection.ProjectionType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class PartitionProjectionService {
    private final boolean partitionProjectionEnabled;
    private final Map<ProjectionType, ProjectionFactory> projectionFactories;
    private final TypeManager typeManager;

    @Inject
    public PartitionProjectionService(HiveConfig hiveConfig, Map<ProjectionType, ProjectionFactory> projectionFactories, TypeManager typeManager) {
        this.partitionProjectionEnabled = hiveConfig.isPartitionProjectionEnabled();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.projectionFactories = ImmutableMap.copyOf(Objects.requireNonNull(projectionFactories, "projectionFactories is null"));
    }

    public Map<String, Object> getPartitionProjectionTrinoTableProperties(Table table) {
        Map<String, String> metastoreTableProperties = table.getParameters();
        ImmutableMap.Builder trinoTablePropertiesBuilder = ImmutableMap.builder();
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, "trino.partition_projection.ignore", "partition_projection_ignore", Boolean::valueOf);
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, "projection.enabled", "partition_projection_enabled", Boolean::valueOf);
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, "storage.location.template", "partition_projection_location_template", String::valueOf);
        return trinoTablePropertiesBuilder.buildOrThrow();
    }

    public Map<String, Object> getPartitionProjectionTrinoColumnProperties(Table table, String columnName) {
        Map<String, String> metastoreTableProperties = table.getParameters();
        return this.rewriteColumnProjectionProperties(metastoreTableProperties, columnName);
    }

    public Map<String, String> getPartitionProjectionHiveTableProperties(ConnectorTableMetadata tableMetadata) {
        if (!this.partitionProjectionEnabled && this.isAnyPartitionProjectionPropertyUsed(tableMetadata)) {
            throw this.columnProjectionException("Partition projection is disabled. Enable it in configuration by setting hive.partition-projection-enabled=true");
        }
        ImmutableMap.Builder metastoreTablePropertiesBuilder = ImmutableMap.builder();
        Map trinoTableProperties = tableMetadata.getProperties();
        this.rewriteProperty(trinoTableProperties, metastoreTablePropertiesBuilder, "partition_projection_ignore", "trino.partition_projection.ignore", value -> value.toString().toLowerCase(Locale.ENGLISH));
        this.rewriteProperty(trinoTableProperties, metastoreTablePropertiesBuilder, "partition_projection_enabled", "projection.enabled", value -> value.toString().toLowerCase(Locale.ENGLISH));
        this.rewriteProperty(trinoTableProperties, metastoreTablePropertiesBuilder, "partition_projection_location_template", "storage.location.template", Object::toString);
        tableMetadata.getColumns().stream().filter(columnMetadata -> !columnMetadata.getProperties().isEmpty()).forEach(columnMetadata -> {
            Map columnProperties = columnMetadata.getProperties();
            String columnName = columnMetadata.getName();
            this.rewriteProperty(columnProperties, metastoreTablePropertiesBuilder, "partition_projection_type", PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "type"), value -> ((ProjectionType)((Object)((Object)((Object)value)))).name().toLowerCase(Locale.ENGLISH));
            this.rewriteProperty(columnProperties, metastoreTablePropertiesBuilder, "partition_projection_values", PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "values"), value -> Joiner.on((String)",").join((Iterable)((List)value)));
            this.rewriteProperty(columnProperties, metastoreTablePropertiesBuilder, "partition_projection_range", PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "range"), value -> Joiner.on((String)",").join((Iterable)((List)value)));
            this.rewriteProperty(columnProperties, metastoreTablePropertiesBuilder, "partition_projection_interval", PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "interval"), value -> ((Integer)value).toString());
            this.rewriteProperty(columnProperties, metastoreTablePropertiesBuilder, "partition_projection_interval_unit", PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "interval.unit"), value -> ((ChronoUnit)value).name().toLowerCase(Locale.ENGLISH));
            this.rewriteProperty(columnProperties, metastoreTablePropertiesBuilder, "partition_projection_digits", PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "digits"), value -> ((Integer)value).toString());
            this.rewriteProperty(columnProperties, metastoreTablePropertiesBuilder, "partition_projection_format", PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "format"), String.class::cast);
        });
        ImmutableMap metastoreTableProperties = metastoreTablePropertiesBuilder.buildOrThrow();
        List<String> partitionColumnNames = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        this.createPartitionProjection((List)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList()), (Map)tableMetadata.getColumns().stream().filter(columnMetadata -> partitionColumnNames.contains(columnMetadata.getName())).collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, ColumnMetadata::getType)), (Map<String, String>)metastoreTableProperties);
        return metastoreTableProperties;
    }

    private boolean isAnyPartitionProjectionPropertyUsed(ConnectorTableMetadata tableMetadata) {
        if (tableMetadata.getProperties().keySet().stream().anyMatch(propertyKey -> propertyKey.startsWith("partition_projection_"))) {
            return true;
        }
        return tableMetadata.getColumns().stream().map(columnMetadata -> columnMetadata.getProperties().keySet()).flatMap(Collection::stream).anyMatch(propertyKey -> propertyKey.startsWith("partition_projection_"));
    }

    public Optional<PartitionProjection> getPartitionProjectionFromTable(Table table) {
        if (!this.partitionProjectionEnabled) {
            return Optional.empty();
        }
        Map<String, String> tableProperties = table.getParameters();
        if (Optional.ofNullable(tableProperties.get("trino.partition_projection.ignore")).map(Boolean::valueOf).orElse(false).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(this.createPartitionProjection((List)table.getDataColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList()), (Map)table.getPartitionColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, column -> column.getType().getType(this.typeManager, HiveTimestampPrecision.DEFAULT_PRECISION))), tableProperties));
    }

    private PartitionProjection createPartitionProjection(List<String> dataColumns, Map<String, Type> partitionColumns, Map<String, String> tableProperties) {
        Optional<Boolean> projectionEnabledProperty = Optional.ofNullable(tableProperties.get("projection.enabled")).map(Boolean::valueOf);
        if (projectionEnabledProperty.orElse(false).booleanValue() && partitionColumns.size() < 1) {
            throw this.columnProjectionException("Partition projection can't be enabled when no partition columns are defined.");
        }
        Map columnProjections = (Map)((ImmutableMap)ImmutableSet.builder().addAll(partitionColumns.keySet()).addAll(dataColumns).build().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), columnName -> this.rewriteColumnProjectionProperties(tableProperties, (String)columnName)))).entrySet().stream().filter(entry -> !((Map)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            String columnName = (String)entry.getKey();
            if (partitionColumns.containsKey(columnName)) {
                return this.parseColumnProjection(columnName, (Type)partitionColumns.get(columnName), (Map)entry.getValue());
            }
            throw this.columnProjectionException("Partition projection can't be defined for non partition column: '" + columnName + "'");
        }));
        Optional<String> storageLocationTemplate = Optional.ofNullable(tableProperties.get("storage.location.template"));
        if (projectionEnabledProperty.isPresent()) {
            for (String columnName2 : partitionColumns.keySet()) {
                String locationTemplate;
                if (!columnProjections.containsKey(columnName2)) {
                    throw this.columnProjectionException("Partition projection definition for column: '" + columnName2 + "' missing");
                }
                if (!storageLocationTemplate.isPresent() || (locationTemplate = storageLocationTemplate.get()).contains("${" + columnName2 + "}")) continue;
                throw this.columnProjectionException(String.format("Partition projection location template: %s is missing partition column: '%s' placeholder", locationTemplate, columnName2));
            }
        } else if (!columnProjections.isEmpty()) {
            throw this.columnProjectionException(String.format("Columns %s projections are disallowed when partition projection property '%s' is missing", columnProjections.keySet().stream().collect(Collectors.joining("', '", "['", "']")), "partition_projection_enabled"));
        }
        return new PartitionProjection(projectionEnabledProperty.orElse(false), storageLocationTemplate, columnProjections);
    }

    private Map<String, Object> rewriteColumnProjectionProperties(Map<String, String> metastoreTableProperties, String columnName) {
        ImmutableMap.Builder trinoTablePropertiesBuilder = ImmutableMap.builder();
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "type"), "partition_projection_type", value -> ProjectionType.valueOf(value.toUpperCase(Locale.ENGLISH)));
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "values"), "partition_projection_values", this::splitCommaSeparatedString);
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "range"), "partition_projection_range", this::splitCommaSeparatedString);
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "interval"), "partition_projection_interval", Integer::valueOf);
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "interval.unit"), "partition_projection_interval_unit", value -> ChronoUnit.valueOf(value.toUpperCase(Locale.ENGLISH)));
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "digits"), "partition_projection_digits", Integer::valueOf);
        this.rewriteProperty(metastoreTableProperties, trinoTablePropertiesBuilder, PartitionProjectionProperties.getMetastoreProjectionPropertyKey(columnName, "format"), "partition_projection_format", value -> value);
        return trinoTablePropertiesBuilder.buildOrThrow();
    }

    private Projection parseColumnProjection(String columnName, Type columnType, Map<String, Object> columnProperties) {
        ProjectionType projectionType = (ProjectionType)((Object)columnProperties.get("partition_projection_type"));
        if (Objects.isNull((Object)projectionType)) {
            throw this.columnProjectionException("Projection type property missing for column: '" + columnName + "'");
        }
        ProjectionFactory projectionFactory = Optional.ofNullable(this.projectionFactories.get((Object)projectionType)).orElseThrow(() -> this.columnProjectionException(String.format("Partition projection type %s for column: '%s' not supported", new Object[]{projectionType, columnName})));
        if (!projectionFactory.isSupportedColumnType(columnType)) {
            throw Projection.unsupportedProjectionColumnTypeException(columnName, columnType);
        }
        return projectionFactory.create(columnName, columnType, columnProperties);
    }

    private <I, V> void rewriteProperty(Map<String, I> sourceProperties, ImmutableMap.Builder<String, V> targetPropertiesBuilder, String sourcePropertyKey, String targetPropertyKey, Function<I, V> valueMapper) {
        Optional.ofNullable(sourceProperties.get(sourcePropertyKey)).ifPresent(value -> targetPropertiesBuilder.put((Object)targetPropertyKey, valueMapper.apply(value)));
    }

    private TrinoException columnProjectionException(String message) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, message);
    }

    private List<String> splitCommaSeparatedString(String value) {
        return Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)value);
    }
}

