/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena.projection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.aws.athena.PartitionProjectionProperties;
import io.trino.plugin.hive.aws.athena.projection.DateProjection;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.plugin.hive.aws.athena.projection.ProjectionFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateProjectionFactory
implements ProjectionFactory {
    public static final ZoneId UTC_TIME_ZONE_ID = ZoneId.of("UTC");
    private static final Set<ChronoUnit> DATE_PROJECTION_INTERVAL_UNITS = ImmutableSet.of((Object)ChronoUnit.DAYS, (Object)ChronoUnit.HOURS, (Object)ChronoUnit.MINUTES, (Object)ChronoUnit.SECONDS);
    private static final Pattern DATE_RANGE_BOUND_EXPRESSION_PATTERN = Pattern.compile("^\\s*NOW\\s*(([+-])\\s*([0-9]+)\\s*(DAY|HOUR|MINUTE|SECOND)S?\\s*)?$");

    @Override
    public boolean isSupportedColumnType(Type columnType) {
        return columnType instanceof VarcharType || columnType instanceof DateType || columnType instanceof TimestampType && ((TimestampType)columnType).isShort();
    }

    @Override
    public Projection create(String columnName, Type columnType, Map<String, Object> columnProperties) {
        String dateFormatPattern = PartitionProjectionProperties.getProjectionPropertyRequiredValue(columnName, columnProperties, "partition_projection_format", String::valueOf);
        List range = (List)PartitionProjectionProperties.getProjectionPropertyRequiredValue(columnName, columnProperties, "partition_projection_range", value -> (ImmutableList)((List)value).stream().map(String.class::cast).collect(ImmutableList.toImmutableList()));
        if (range.size() != 2) {
            throw this.invalidRangeProperty(columnName, dateFormatPattern);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatPattern);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(TimeZone.getTimeZone(UTC_TIME_ZONE_ID));
        Supplier<Instant> leftBound = this.parseDateRangerBound(columnName, (String)range.get(0), dateFormat);
        Supplier<Instant> rangeBound = this.parseDateRangerBound(columnName, (String)range.get(1), dateFormat);
        if (!leftBound.get().isBefore(rangeBound.get())) {
            throw this.invalidRangeProperty(columnName, dateFormatPattern);
        }
        int interval = PartitionProjectionProperties.getProjectionPropertyValue(columnProperties, "partition_projection_interval", Integer.class::cast).orElse(1);
        ChronoUnit intervalUnit = PartitionProjectionProperties.getProjectionPropertyValue(columnProperties, "partition_projection_interval_unit", ChronoUnit.class::cast).orElseGet(() -> this.resolveDefaultChronoUnit(columnName, dateFormatPattern));
        if (!DATE_PROJECTION_INTERVAL_UNITS.contains(intervalUnit)) {
            throw Projection.invalidProjectionException(columnName, String.format("Property: '%s' value '%s' is invalid. Available options: %s", "partition_projection_interval_unit", intervalUnit, DATE_PROJECTION_INTERVAL_UNITS));
        }
        return new DateProjection(columnName, dateFormat, leftBound, rangeBound, interval, intervalUnit);
    }

    private ChronoUnit resolveDefaultChronoUnit(String columnName, String dateFormatPattern) {
        String datePatternWithoutText = dateFormatPattern.replaceAll("'.*?'", "");
        if (datePatternWithoutText.contains("S") || datePatternWithoutText.contains("s") || datePatternWithoutText.contains("m") || datePatternWithoutText.contains("H")) {
            throw Projection.invalidProjectionException(columnName, String.format("Property: '%s' needs to be set when provided '%s' is less that single-day precision. Interval defaults to 1 day or 1 month, respectively. Otherwise, interval is required", "partition_projection_interval_unit", "partition_projection_format"));
        }
        if (datePatternWithoutText.contains("d")) {
            return ChronoUnit.DAYS;
        }
        return ChronoUnit.MONTHS;
    }

    private Supplier<Instant> parseDateRangerBound(String columnName, String value, SimpleDateFormat dateFormat) {
        Instant dateBound;
        Matcher matcher = DATE_RANGE_BOUND_EXPRESSION_PATTERN.matcher(value);
        if (matcher.matches()) {
            String operator = matcher.group(2);
            String multiplierString = matcher.group(3);
            String unitString = matcher.group(4);
            if (Objects.nonNull(operator) && Objects.nonNull(multiplierString) && Objects.nonNull(unitString)) {
                unitString = unitString.toUpperCase(Locale.ENGLISH);
                return new DateExpressionBound(Integer.parseInt(multiplierString), ChronoUnit.valueOf(unitString + "S"), operator.charAt(0) == '+');
            }
            if (value.trim().equals("NOW")) {
                Instant now = Instant.now();
                return () -> now;
            }
            throw this.invalidRangeProperty(columnName, dateFormat.toPattern(), Optional.of("Invalid expression"));
        }
        try {
            dateBound = dateFormat.parse(value).toInstant();
        }
        catch (ParseException e) {
            throw this.invalidRangeProperty(columnName, dateFormat.toPattern(), Optional.of(e.getMessage()));
        }
        return () -> dateBound;
    }

    private TrinoException invalidRangeProperty(String columnName, String dateFormatPattern) {
        return this.invalidRangeProperty(columnName, dateFormatPattern, Optional.empty());
    }

    private TrinoException invalidRangeProperty(String columnName, String dateFormatPattern, Optional<String> errorDetail) {
        return Projection.invalidProjectionException(columnName, String.format("Property: '%s' needs to be a list of 2 valid dates formatted as '%s' or '%s' that are sequential%s", "partition_projection_range", dateFormatPattern, DATE_RANGE_BOUND_EXPRESSION_PATTERN.pattern(), errorDetail.map(error -> ". " + error).orElse("")));
    }

    private static class DateExpressionBound
    implements Supplier<Instant> {
        private final int multiplier;
        private final ChronoUnit unit;
        private final boolean increment;

        public DateExpressionBound(int multiplier, ChronoUnit unit, boolean increment) {
            this.multiplier = multiplier;
            this.unit = unit;
            this.increment = increment;
        }

        @Override
        public Instant get() {
            return Instant.now().plus(this.increment ? (long)this.multiplier : (long)(-this.multiplier), this.unit);
        }
    }
}

