/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.SizeOf;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.orc.OrcCorruptionException;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.BackgroundHiveSplitLoader;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.trino.plugin.hive.util.AcidBucketCodec;
import io.trino.plugin.hive.util.AcidTables;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.Path;

@NotThreadSafe
public class OrcDeletedRows {
    private static final int ORIGINAL_TRANSACTION_INDEX = 0;
    private static final int BUCKET_ID_INDEX = 1;
    private static final int ROW_ID_INDEX = 2;
    private static final long DELETED_ROWS_MEMORY_INCREASE_YIELD_THREHOLD = 39452672L;
    private final String sourceFileName;
    private final OrcDeleteDeltaPageSourceFactory pageSourceFactory;
    private final TrinoFileSystem fileSystem;
    private final AcidInfo acidInfo;
    private final OptionalInt bucketNumber;
    private final LocalMemoryContext memoryUsage;
    private State state = State.NOT_LOADED;
    @Nullable
    private Loader loader;
    @Nullable
    private Set<RowId> deletedRows;

    public OrcDeletedRows(String sourceFileName, OrcDeleteDeltaPageSourceFactory pageSourceFactory, ConnectorIdentity identity, TrinoFileSystemFactory fileSystemFactory, AcidInfo acidInfo, OptionalInt bucketNumber, AggregatedMemoryContext memoryContext) {
        this.sourceFileName = Objects.requireNonNull(sourceFileName, "sourceFileName is null");
        this.pageSourceFactory = Objects.requireNonNull(pageSourceFactory, "pageSourceFactory is null");
        this.fileSystem = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null").create(identity);
        this.acidInfo = Objects.requireNonNull(acidInfo, "acidInfo is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        this.memoryUsage = memoryContext.newLocalMemoryContext(OrcDeletedRows.class.getSimpleName());
    }

    public MaskDeletedRowsFunction getMaskDeletedRowsFunction(Page sourcePage, OptionalLong startRowId) {
        return new MaskDeletedRows(sourcePage, startRowId);
    }

    private Set<RowId> getDeletedRows() {
        Preconditions.checkState((this.state == State.LOADED ? 1 : 0) != 0, (String)"expected LOADED state but was %s", (Object)((Object)this.state));
        Verify.verify((this.deletedRows != null ? 1 : 0) != 0, (String)"deleted rows null despite LOADED state", (Object[])new Object[0]);
        return this.deletedRows;
    }

    public boolean loadOrYield() {
        Preconditions.checkState((this.state != State.CLOSED ? 1 : 0) != 0, (Object)"already closed");
        if (this.state == State.NOT_LOADED) {
            this.loader = new Loader();
            this.state = State.LOADING;
        }
        if (this.state == State.LOADING) {
            Verify.verify((this.loader != null ? 1 : 0) != 0, (String)"loader not set despite LOADING state", (Object[])new Object[0]);
            Optional<Set<RowId>> loadedRowIds = this.loader.loadOrYield();
            if (loadedRowIds.isPresent()) {
                this.deletedRows = loadedRowIds.get();
                try {
                    this.loader.close();
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, "Failed to close deletedRows loader", (Throwable)e);
                }
                this.loader = null;
                this.state = State.LOADED;
            }
        }
        return this.state == State.LOADED;
    }

    public void close() throws IOException {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.loader != null) {
            this.loader.close();
            this.loader = null;
        }
        this.state = State.CLOSED;
    }

    private static long retainedMemorySize(int rowCount, @Nullable Page currentPage) {
        long pageSize = currentPage != null ? currentPage.getRetainedSizeInBytes() : 0L;
        return SizeOf.sizeOfObjectArray((int)rowCount) + (long)rowCount * (long)RowId.INSTANCE_SIZE + pageSize;
    }

    private static Path createPath(AcidInfo acidInfo, String deleteDeltaDirectory, String fileName) {
        Path directory = new Path(acidInfo.getPartitionLocation(), deleteDeltaDirectory);
        if (BackgroundHiveSplitLoader.hasAttemptId(fileName)) {
            return new Path(directory, fileName.substring(0, fileName.lastIndexOf(95)));
        }
        if (!acidInfo.getOriginalFiles().isEmpty()) {
            return AcidTables.bucketFileName(directory, acidInfo.getBucketId());
        }
        return new Path(directory, fileName);
    }

    private static enum State {
        NOT_LOADED,
        LOADING,
        LOADED,
        CLOSED;

    }

    @NotThreadSafe
    private class MaskDeletedRows
    implements MaskDeletedRowsFunction {
        @Nullable
        private Page sourcePage;
        private int positionCount;
        @Nullable
        private int[] validPositions;
        private final OptionalLong startRowId;

        public MaskDeletedRows(Page sourcePage, OptionalLong startRowId) {
            this.sourcePage = Objects.requireNonNull(sourcePage, "sourcePage is null");
            this.startRowId = Objects.requireNonNull(startRowId, "startRowId is null");
        }

        @Override
        public int getPositionCount() {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            return this.positionCount;
        }

        @Override
        public Block apply(Block block) {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            if (this.positionCount == block.getPositionCount()) {
                return block;
            }
            return DictionaryBlock.create((int)this.positionCount, (Block)block, (int[])this.validPositions);
        }

        private void loadValidPositions() {
            Verify.verify((this.sourcePage != null ? 1 : 0) != 0, (String)"sourcePage is null", (Object[])new Object[0]);
            Set<RowId> deletedRows = OrcDeletedRows.this.getDeletedRows();
            if (deletedRows.isEmpty()) {
                this.positionCount = this.sourcePage.getPositionCount();
                this.sourcePage = null;
                return;
            }
            int[] validPositions = new int[this.sourcePage.getPositionCount()];
            int validPositionsIndex = 0;
            for (int position = 0; position < this.sourcePage.getPositionCount(); ++position) {
                RowId rowId = this.getRowId(position);
                if (deletedRows.contains(rowId)) continue;
                validPositions[validPositionsIndex] = position;
                ++validPositionsIndex;
            }
            this.positionCount = validPositionsIndex;
            this.validPositions = validPositions;
            this.sourcePage = null;
        }

        private RowId getRowId(int position) {
            long row;
            int statementId;
            int bucket;
            long originalTransaction;
            Verify.verify((this.sourcePage != null ? 1 : 0) != 0, (String)"sourcePage is null", (Object[])new Object[0]);
            if (this.startRowId.isPresent()) {
                originalTransaction = 0L;
                bucket = OrcDeletedRows.this.bucketNumber.orElse(0);
                statementId = 0;
                row = this.startRowId.getAsLong() + (long)position;
            } else {
                originalTransaction = BigintType.BIGINT.getLong(this.sourcePage.getBlock(0), position);
                int encodedBucketValue = Math.toIntExact(IntegerType.INTEGER.getLong(this.sourcePage.getBlock(1), position));
                AcidBucketCodec bucketCodec = AcidBucketCodec.forBucket(encodedBucketValue);
                bucket = bucketCodec.decodeWriterId(encodedBucketValue);
                statementId = bucketCodec.decodeStatementId(encodedBucketValue);
                row = BigintType.BIGINT.getLong(this.sourcePage.getBlock(2), position);
            }
            return new RowId(originalTransaction, bucket, statementId, row);
        }
    }

    private class Loader {
        private final ImmutableSet.Builder<RowId> deletedRowsBuilder = ImmutableSet.builder();
        private int deletedRowsBuilderSize;
        @Nullable
        private Iterator<String> deleteDeltaDirectories;
        @Nullable
        private ConnectorPageSource currentPageSource;
        @Nullable
        private Path currentPath;
        @Nullable
        private Page currentPage;
        private int currentPagePosition;

        private Loader() {
        }

        public Optional<Set<RowId>> loadOrYield() {
            long initialMemorySize = OrcDeletedRows.retainedMemorySize(this.deletedRowsBuilderSize, this.currentPage);
            if (this.deleteDeltaDirectories == null) {
                this.deleteDeltaDirectories = OrcDeletedRows.this.acidInfo.getDeleteDeltaDirectories().iterator();
            }
            while (this.deleteDeltaDirectories.hasNext() || this.currentPageSource != null) {
                try {
                    if (this.currentPageSource == null) {
                        String deleteDeltaDirectory = this.deleteDeltaDirectories.next();
                        this.currentPath = OrcDeletedRows.createPath(OrcDeletedRows.this.acidInfo, deleteDeltaDirectory, OrcDeletedRows.this.sourceFileName);
                        TrinoInputFile inputFile = OrcDeletedRows.this.fileSystem.newInputFile(this.currentPath.toString());
                        if (inputFile.exists()) {
                            this.currentPageSource = OrcDeletedRows.this.pageSourceFactory.createPageSource(inputFile).orElseGet(EmptyPageSource::new);
                        }
                    }
                    if (this.currentPageSource == null) continue;
                    while (!this.currentPageSource.isFinished() || this.currentPage != null) {
                        if (this.currentPage == null) {
                            this.currentPage = this.currentPageSource.getNextPage();
                            this.currentPagePosition = 0;
                        }
                        if (this.currentPage == null) continue;
                        while (this.currentPagePosition < this.currentPage.getPositionCount()) {
                            long currentMemorySize;
                            long originalTransaction = BigintType.BIGINT.getLong(this.currentPage.getBlock(0), this.currentPagePosition);
                            int encodedBucketValue = Math.toIntExact(IntegerType.INTEGER.getLong(this.currentPage.getBlock(1), this.currentPagePosition));
                            AcidBucketCodec bucketCodec = AcidBucketCodec.forBucket(encodedBucketValue);
                            int bucket = bucketCodec.decodeWriterId(encodedBucketValue);
                            int statement = bucketCodec.decodeStatementId(encodedBucketValue);
                            long row = BigintType.BIGINT.getLong(this.currentPage.getBlock(2), this.currentPagePosition);
                            RowId rowId = new RowId(originalTransaction, bucket, statement, row);
                            this.deletedRowsBuilder.add((Object)rowId);
                            ++this.deletedRowsBuilderSize;
                            ++this.currentPagePosition;
                            if (this.deletedRowsBuilderSize % 1000 != 0 || (currentMemorySize = OrcDeletedRows.retainedMemorySize(this.deletedRowsBuilderSize, this.currentPage)) - initialMemorySize < 39452672L) continue;
                            OrcDeletedRows.this.memoryUsage.setBytes(currentMemorySize);
                            return Optional.empty();
                        }
                        this.currentPage = null;
                    }
                    this.currentPageSource.close();
                    this.currentPageSource = null;
                }
                catch (TrinoException e) {
                    throw e;
                }
                catch (OrcCorruptionException e) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Failed to read ORC delete delta file: " + this.currentPath, (Throwable)e);
                }
                catch (IOException | RuntimeException e) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, "Failed to read ORC delete delta file: " + this.currentPath, (Throwable)e);
                }
            }
            ImmutableSet builtDeletedRows = this.deletedRowsBuilder.build();
            OrcDeletedRows.this.memoryUsage.setBytes(OrcDeletedRows.retainedMemorySize(builtDeletedRows.size(), null));
            return Optional.of(builtDeletedRows);
        }

        public void close() throws IOException {
            if (this.currentPageSource != null) {
                this.currentPageSource.close();
                this.currentPageSource = null;
            }
        }
    }

    private static class RowId {
        public static final int INSTANCE_SIZE = SizeOf.instanceSize(RowId.class);
        private final long originalTransaction;
        private final int bucket;
        private final int statementId;
        private final long rowId;

        public RowId(long originalTransaction, int bucket, int statementId, long rowId) {
            this.originalTransaction = originalTransaction;
            this.bucket = bucket;
            this.statementId = statementId;
            this.rowId = rowId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowId other = (RowId)o;
            return this.originalTransaction == other.originalTransaction && this.bucket == other.bucket && this.statementId == other.statementId && this.rowId == other.rowId;
        }

        public int hashCode() {
            return Objects.hash(this.originalTransaction, this.bucket, this.statementId, this.rowId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("originalTransaction", this.originalTransaction).add("bucket", this.bucket).add("statementId", this.statementId).add("rowId", this.rowId).toString();
        }
    }

    public static interface MaskDeletedRowsFunction {
        public int getPositionCount();

        public Block apply(Block var1);

        public static MaskDeletedRowsFunction noMaskForPage(Page page) {
            final int positionCount = page.getPositionCount();
            return new MaskDeletedRowsFunction(){

                @Override
                public int getPositionCount() {
                    return positionCount;
                }

                @Override
                public Block apply(Block block) {
                    return block;
                }
            };
        }
    }
}

