/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.reader.ParquetReader;
import io.trino.parquet.reader.ParquetReaderColumn;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class ParquetPageSource
implements ConnectorPageSource {
    private final ParquetReader parquetReader;
    private final List<ParquetReaderColumn> parquetReaderColumns;
    private final boolean areSyntheticColumnsPresent;
    private boolean closed;
    private long completedPositions;

    public ParquetPageSource(ParquetReader parquetReader, List<ParquetReaderColumn> parquetReaderColumns) {
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
        this.parquetReaderColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(parquetReaderColumns, "parquetReaderColumns is null"));
        this.areSyntheticColumnsPresent = parquetReaderColumns.stream().anyMatch(column -> column.isRowIndexColumn() || column.field().isEmpty());
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.parquetReader.getDataSource().getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getMemoryUsage() {
        return this.parquetReader.getMemoryContext().getBytes();
    }

    public Page getNextPage() {
        Page page;
        try {
            page = this.getColumnAdaptationsPage(this.parquetReader.nextPage());
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw ParquetPageSource.handleException(this.parquetReader.getDataSource().getId(), e);
        }
        if (this.closed || page == null) {
            this.close();
            return null;
        }
        this.completedPositions += (long)page.getPositionCount();
        return page;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Metrics getMetrics() {
        return this.parquetReader.getMetrics();
    }

    private Page getColumnAdaptationsPage(Page page) {
        if (!this.areSyntheticColumnsPresent) {
            return page;
        }
        if (page == null) {
            return null;
        }
        int batchSize = page.getPositionCount();
        Block[] blocks = new Block[this.parquetReaderColumns.size()];
        int sourceColumn = 0;
        for (int columnIndex = 0; columnIndex < this.parquetReaderColumns.size(); ++columnIndex) {
            ParquetReaderColumn column = this.parquetReaderColumns.get(columnIndex);
            if (column.isRowIndexColumn()) {
                blocks[columnIndex] = ParquetPageSource.getRowIndexColumn(this.parquetReader.lastBatchStartRow(), batchSize);
                continue;
            }
            if (column.field().isEmpty()) {
                blocks[columnIndex] = RunLengthEncodedBlock.create((Type)column.type(), null, (int)batchSize);
                continue;
            }
            blocks[columnIndex] = page.getBlock(sourceColumn);
            ++sourceColumn;
        }
        return new Page(batchSize, blocks);
    }

    static TrinoException handleException(ParquetDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)((Object)exception);
        }
        if (exception instanceof ParquetCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read Parquet file: %s", dataSourceId), (Throwable)exception);
    }

    private static Block getRowIndexColumn(long baseIndex, int size) {
        long[] rowIndices = new long[size];
        for (int position = 0; position < size; ++position) {
            rowIndices[position] = baseIndex + (long)position;
        }
        return new LongArrayBlock(size, Optional.empty(), rowIndices);
    }
}

