/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public class RecordReaderUtils {
    private RecordReaderUtils() {
    }

    public static BufferedReader getBufferedReader(File dataFile) throws IOException {
        return new BufferedReader(new InputStreamReader(RecordReaderUtils.getInputStream(dataFile), StandardCharsets.UTF_8));
    }

    public static BufferedInputStream getBufferedInputStream(File dataFile) throws IOException {
        return new BufferedInputStream(RecordReaderUtils.getInputStream(dataFile));
    }

    public static InputStream getInputStream(File dataFile) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(dataFile);
        try {
            return new GZIPInputStream(fileInputStream);
        }
        catch (Exception e) {
            fileInputStream.close();
            return new FileInputStream(dataFile);
        }
    }
}

