/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSizeUtils {
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^(\\d+(\\.\\d+)?)([KMGTP])?(B)?$", 2);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");
    private static final double KB_IN_BYTES = 1024.0;
    private static final double MB_IN_BYTES = 1048576.0;
    private static final double GB_IN_BYTES = 1.073741824E9;
    private static final double TB_IN_BYTES = 1.099511627776E12;
    private static final double PB_IN_BYTES = 1.125899906842624E15;

    private DataSizeUtils() {
    }

    public static long toBytes(String dataSizeString) {
        Matcher matcher = DATA_SIZE_PATTERN.matcher(dataSizeString);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Illegal data size: %s", (Object)dataSizeString);
        double value = Double.parseDouble(matcher.group(1));
        String unit = matcher.group(3);
        if (unit != null) {
            switch (unit.toUpperCase()) {
                case "K": {
                    return (long)(value * 1024.0);
                }
                case "M": {
                    return (long)(value * 1048576.0);
                }
                case "G": {
                    return (long)(value * 1.073741824E9);
                }
                case "T": {
                    return (long)(value * 1.099511627776E12);
                }
                case "P": {
                    return (long)(value * 1.125899906842624E15);
                }
            }
            throw new IllegalStateException();
        }
        return (long)value;
    }

    public static String fromBytes(long dataSizeInBytes) {
        if ((double)dataSizeInBytes < 1024.0) {
            return dataSizeInBytes + "B";
        }
        if ((double)dataSizeInBytes < 1048576.0) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / 1024.0) + "K";
        }
        if ((double)dataSizeInBytes < 1.073741824E9) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / 1048576.0) + "M";
        }
        if ((double)dataSizeInBytes < 1.099511627776E12) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / 1.073741824E9) + "G";
        }
        if ((double)dataSizeInBytes < 1.125899906842624E15) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / 1.099511627776E12) + "T";
        }
        return DECIMAL_FORMAT.format((double)dataSizeInBytes / 1.125899906842624E15) + "P";
    }
}

