/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.FieldValueProviders;
import io.trino.decoder.RowDecoder;
import io.trino.plugin.kinesis.KinesisClientProvider;
import io.trino.plugin.kinesis.KinesisColumnHandle;
import io.trino.plugin.kinesis.KinesisCompressionCodec;
import io.trino.plugin.kinesis.KinesisInternalFieldDescription;
import io.trino.plugin.kinesis.KinesisSessionProperties;
import io.trino.plugin.kinesis.KinesisShardCheckpointer;
import io.trino.plugin.kinesis.KinesisSplit;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.GZIPInputStream;

public class KinesisRecordSet
implements RecordSet {
    private static final int MILLIS_BEHIND_LIMIT = 10000;
    private static final Logger log = Logger.get(KinesisRecordSet.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final KinesisSplit split;
    private final ConnectorSession session;
    private final KinesisClientProvider clientManager;
    private final RowDecoder messageDecoder;
    private final List<KinesisColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final int batchSize;
    private final int maxBatches;
    private final int fetchAttempts;
    private final long sleepTime;
    private final boolean isLogBatches;
    private final boolean checkpointEnabled;
    private final KinesisShardCheckpointer shardCheckpointer;
    private String lastReadSequenceNumber;

    KinesisRecordSet(KinesisSplit split, ConnectorSession session, KinesisClientProvider clientManager, List<KinesisColumnHandle> columnHandles, RowDecoder messageDecoder, long dynamoReadCapacity, long dynamoWriteCapacity, boolean isLogBatches, int fetchAttempts, Duration sleepTime) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.isLogBatches = isLogBatches;
        this.clientManager = Objects.requireNonNull(clientManager, "clientManager is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.messageDecoder = messageDecoder;
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (KinesisColumnHandle handle : columnHandles) {
            typeBuilder.add((Object)handle.getType());
        }
        this.columnTypes = typeBuilder.build();
        this.batchSize = KinesisSessionProperties.getBatchSize(session);
        this.maxBatches = KinesisSessionProperties.getMaxBatches(this.session);
        this.fetchAttempts = fetchAttempts;
        this.sleepTime = sleepTime.toMillis();
        this.checkpointEnabled = KinesisSessionProperties.isCheckpointEnabled(session);
        this.lastReadSequenceNumber = null;
        if (this.checkpointEnabled) {
            AmazonDynamoDBClient dynamoDBClient = clientManager.getDynamoDbClient();
            String dynamoDBTable = split.getStreamName();
            int curIterationNumber = KinesisSessionProperties.getIterationNumber(session);
            String sessionLogicalName = KinesisSessionProperties.getCheckpointLogicalName(session);
            String logicalProcessName = null;
            if (sessionLogicalName != null) {
                logicalProcessName = sessionLogicalName;
            }
            this.shardCheckpointer = new KinesisShardCheckpointer((AmazonDynamoDB)dynamoDBClient, dynamoDBTable, split, logicalProcessName, curIterationNumber, dynamoReadCapacity, dynamoWriteCapacity);
            this.lastReadSequenceNumber = this.shardCheckpointer.getLastReadSeqNumber();
        } else {
            this.shardCheckpointer = null;
        }
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new KinesisRecordCursor();
    }

    private static boolean isGZipped(byte[] data) {
        if (data == null || data.length < 2) {
            return false;
        }
        int magic = data[0] & 0xFF | data[1] << 8 & 0xFF00;
        return magic == 35615;
    }

    public class KinesisRecordCursor
    implements RecordCursor {
        private final FieldValueProvider[] currentRowValues;
        private long batchesRead;
        private long messagesRead;
        private long totalBytes;
        private long totalMessages;
        private long lastReadTime;
        private String shardIterator;
        private List<Record> kinesisRecords;
        private Iterator<Record> listIterator;
        private GetRecordsRequest getRecordsRequest;
        private GetRecordsResult getRecordsResult;

        public KinesisRecordCursor() {
            this.currentRowValues = new FieldValueProvider[KinesisRecordSet.this.columnHandles.size()];
        }

        public long getCompletedBytes() {
            return this.totalBytes;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkArgument((field < KinesisRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return KinesisRecordSet.this.columnHandles.get(field).getType();
        }

        public boolean advanceNextPosition() {
            if (this.shardIterator == null && this.getRecordsRequest == null) {
                this.getIterator();
                log.debug("(%s:%s) Starting read.  Retrieved first shard iterator from AWS Kinesis.", new Object[]{KinesisRecordSet.this.split.getStreamName(), KinesisRecordSet.this.split.getShardId()});
            }
            if (this.getRecordsRequest == null || !this.listIterator.hasNext() && this.shouldGetMoreRecords()) {
                this.getKinesisRecords();
            }
            if (this.listIterator.hasNext()) {
                return this.nextRow();
            }
            log.debug("(%s:%s) Read all of the records from the shard:  %d batches and %d messages and %d total bytes.", new Object[]{KinesisRecordSet.this.split.getStreamName(), KinesisRecordSet.this.split.getShardId(), this.batchesRead, this.totalMessages, this.totalBytes});
            return false;
        }

        private boolean shouldGetMoreRecords() {
            return this.shardIterator != null && this.batchesRead < (long)KinesisRecordSet.this.maxBatches && this.getMillisBehindLatest() > 10000L;
        }

        private void getKinesisRecords() throws ResourceNotFoundException {
            boolean fetchedRecords = false;
            for (int attempts = 0; !fetchedRecords && attempts < KinesisRecordSet.this.fetchAttempts; ++attempts) {
                Duration duration = Duration.nanosSince((long)this.lastReadTime);
                if (duration.toMillis() <= KinesisRecordSet.this.sleepTime) {
                    try {
                        Thread.sleep(duration.toMillis());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("thread interrupted");
                    }
                }
                this.getRecordsRequest = new GetRecordsRequest();
                this.getRecordsRequest.setShardIterator(this.shardIterator);
                this.getRecordsRequest.setLimit(Integer.valueOf(KinesisRecordSet.this.batchSize));
                this.getRecordsResult = KinesisRecordSet.this.clientManager.getClient().getRecords(this.getRecordsRequest);
                this.lastReadTime = System.nanoTime();
                this.shardIterator = this.getRecordsResult.getNextShardIterator();
                this.kinesisRecords = this.getRecordsResult.getRecords();
                if (KinesisRecordSet.this.isLogBatches) {
                    log.info("(%s:%s) Fetched %d records from Kinesis.  MillisBehindLatest=%d Attempt=%d", new Object[]{KinesisRecordSet.this.split.getStreamName(), KinesisRecordSet.this.split.getShardId(), this.kinesisRecords.size(), this.getRecordsResult.getMillisBehindLatest(), attempts});
                }
                fetchedRecords = this.kinesisRecords.size() > 0 || this.getMillisBehindLatest() <= 10000L;
            }
            this.listIterator = this.kinesisRecords.iterator();
            ++this.batchesRead;
            this.messagesRead += (long)this.kinesisRecords.size();
        }

        private boolean nextRow() {
            Record currentRecord = this.listIterator.next();
            String partitionKey = currentRecord.getPartitionKey();
            log.debug("(%s:%s) Reading record with partition key %s", new Object[]{KinesisRecordSet.this.split.getStreamName(), KinesisRecordSet.this.split.getShardId(), partitionKey});
            byte[] messageData = EMPTY_BYTE_ARRAY;
            ByteBuffer message = currentRecord.getData();
            if (message != null) {
                messageData = new byte[message.remaining()];
                message.get(messageData);
            }
            this.totalBytes += (long)messageData.length;
            ++this.totalMessages;
            log.debug("(%s:%s) Fetching %d bytes from current record. %d messages read so far", new Object[]{KinesisRecordSet.this.split.getStreamName(), KinesisRecordSet.this.split.getShardId(), messageData.length, this.totalMessages});
            Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodedValue = this.decodeMessage(messageData);
            HashMap<DecoderColumnHandle, FieldValueProvider> currentRowValuesMap = new HashMap<DecoderColumnHandle, FieldValueProvider>();
            block9: for (DecoderColumnHandle decoderColumnHandle : KinesisRecordSet.this.columnHandles) {
                if (!decoderColumnHandle.isInternal()) continue;
                KinesisInternalFieldDescription fieldDescription = KinesisInternalFieldDescription.forColumnName(decoderColumnHandle.getName());
                switch (fieldDescription) {
                    case SHARD_ID_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])KinesisRecordSet.this.split.getShardId().getBytes(StandardCharsets.UTF_8)));
                        continue block9;
                    }
                    case SEGMENT_START_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])KinesisRecordSet.this.split.getStart().getBytes(StandardCharsets.UTF_8)));
                        continue block9;
                    }
                    case SEGMENT_COUNT_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)this.totalMessages));
                        continue block9;
                    }
                    case SHARD_SEQUENCE_ID_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])currentRecord.getSequenceNumber().getBytes(StandardCharsets.UTF_8)));
                        continue block9;
                    }
                    case MESSAGE_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])messageData));
                        continue block9;
                    }
                    case MESSAGE_LENGTH_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)messageData.length));
                        continue block9;
                    }
                    case MESSAGE_VALID_FIELD: {
                        currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.booleanValueProvider((boolean)decodedValue.isEmpty()));
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("unknown internal field " + fieldDescription);
            }
            decodedValue.ifPresent(currentRowValuesMap::putAll);
            for (int i = 0; i < KinesisRecordSet.this.columnHandles.size(); ++i) {
                ColumnHandle columnHandle = (ColumnHandle)KinesisRecordSet.this.columnHandles.get(i);
                this.currentRowValues[i] = (FieldValueProvider)currentRowValuesMap.get(columnHandle);
            }
            return true;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeMessage(byte[] messageData) {
            KinesisCompressionCodec kinesisCompressionCodec = KinesisRecordSet.this.split.getCompressionCodec();
            if (kinesisCompressionCodec == KinesisCompressionCodec.UNCOMPRESSED) {
                return KinesisRecordSet.this.messageDecoder.decodeRow(messageData);
            }
            if (KinesisRecordSet.isGZipped(messageData)) {
                if (!KinesisCompressionCodec.canUseGzip(kinesisCompressionCodec)) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("A %s message was found that did not match the required %s compression codec. Consider using %s or %s compressionCodec in table description", new Object[]{KinesisCompressionCodec.GZIP, kinesisCompressionCodec, KinesisCompressionCodec.GZIP, KinesisCompressionCodec.AUTOMATIC}));
                }
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(messageData);){
                    Optional optional;
                    try (GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);){
                        optional = KinesisRecordSet.this.messageDecoder.decodeRow(gZIPInputStream.readAllBytes());
                    }
                    return optional;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
                }
            }
            if (kinesisCompressionCodec == KinesisCompressionCodec.AUTOMATIC) {
                return KinesisRecordSet.this.messageDecoder.decodeRow(messageData);
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("A message was found that did not match the required %s compression codec. Consider using %s or %s compressionCodec in table description", new Object[]{kinesisCompressionCodec, KinesisCompressionCodec.UNCOMPRESSED, KinesisCompressionCodec.AUTOMATIC}));
        }

        private long getMillisBehindLatest() {
            if (this.getRecordsResult != null && this.getRecordsResult.getMillisBehindLatest() != null) {
                return this.getRecordsResult.getMillisBehindLatest();
            }
            return 10001L;
        }

        public boolean getBoolean(int field) {
            return this.getFieldValueProvider(field, Boolean.TYPE).getBoolean();
        }

        public long getLong(int field) {
            return this.getFieldValueProvider(field, Long.TYPE).getLong();
        }

        public double getDouble(int field) {
            return this.getFieldValueProvider(field, Double.TYPE).getDouble();
        }

        public Slice getSlice(int field) {
            return this.getFieldValueProvider(field, Slice.class).getSlice();
        }

        public Object getObject(int field) {
            return this.getFieldValueProvider(field, Block.class).getBlock();
        }

        public boolean isNull(int field) {
            Preconditions.checkArgument((field < KinesisRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return this.currentRowValues[field] == null || this.currentRowValues[field].isNull();
        }

        private FieldValueProvider getFieldValueProvider(int field, Class<?> expectedType) {
            Preconditions.checkArgument((field < KinesisRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, expectedType);
            return this.currentRowValues[field];
        }

        public void close() {
            log.info("(%s:%s) Closing cursor - read complete.  Total read: %d batches %d messages, processed: %d messages and %d bytes.", new Object[]{KinesisRecordSet.this.split.getStreamName(), KinesisRecordSet.this.split.getShardId(), this.batchesRead, this.messagesRead, this.totalMessages, this.totalBytes});
            if (KinesisRecordSet.this.checkpointEnabled && KinesisRecordSet.this.lastReadSequenceNumber != null) {
                KinesisRecordSet.this.shardCheckpointer.checkpoint(KinesisRecordSet.this.lastReadSequenceNumber);
            }
        }

        private void checkFieldType(int field, Class<?> expected) {
            Class actual = this.getType(field).getJavaType();
            Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
        }

        private void getIterator() throws ResourceNotFoundException {
            GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest();
            getShardIteratorRequest.setStreamName(KinesisRecordSet.this.split.getStreamName());
            getShardIteratorRequest.setShardId(KinesisRecordSet.this.split.getShardId());
            if (KinesisRecordSet.this.lastReadSequenceNumber == null) {
                if (KinesisSessionProperties.isIteratorFromTimestamp(KinesisRecordSet.this.session)) {
                    getShardIteratorRequest.setShardIteratorType("AT_TIMESTAMP");
                    long iteratorStartTimestamp = KinesisSessionProperties.getIteratorStartTimestamp(KinesisRecordSet.this.session);
                    if (iteratorStartTimestamp == 0L) {
                        long startTimestamp = System.currentTimeMillis() - KinesisSessionProperties.getIteratorOffsetSeconds(KinesisRecordSet.this.session) * 1000L;
                        getShardIteratorRequest.setTimestamp(new Date(startTimestamp));
                    } else {
                        getShardIteratorRequest.setTimestamp(new Date(iteratorStartTimestamp));
                    }
                } else {
                    getShardIteratorRequest.setShardIteratorType("TRIM_HORIZON");
                }
            } else {
                getShardIteratorRequest.setShardIteratorType("AFTER_SEQUENCE_NUMBER");
                getShardIteratorRequest.setStartingSequenceNumber(KinesisRecordSet.this.lastReadSequenceNumber);
            }
            GetShardIteratorResult getShardIteratorResult = KinesisRecordSet.this.clientManager.getClient().getShardIterator(getShardIteratorRequest);
            this.shardIterator = getShardIteratorResult.getShardIterator();
        }
    }
}

