/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client.testing;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryAnnouncementClient;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.MergingServiceSelectorFactory;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorFactory;
import io.airlift.discovery.client.ServiceSelectorManager;
import io.airlift.discovery.client.testing.InMemoryDiscoveryClient;
import io.airlift.discovery.client.testing.SimpleServiceSelectorFactory;
import io.airlift.node.NodeInfo;
import javax.inject.Singleton;

public class TestingDiscoveryModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(InMemoryDiscoveryClient.class).in(Scopes.SINGLETON);
        binder.bind(DiscoveryAnnouncementClient.class).to(Key.get(InMemoryDiscoveryClient.class)).in(Scopes.SINGLETON);
        binder.bind(DiscoveryLookupClient.class).to(Key.get(InMemoryDiscoveryClient.class)).in(Scopes.SINGLETON);
        binder.bind(Announcer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
        binder.bind(SimpleServiceSelectorFactory.class).in(Scopes.SINGLETON);
        binder.bind(ServiceSelectorFactory.class).to(MergingServiceSelectorFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ServiceSelector.class);
        binder.bind(ServiceSelectorManager.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public MergingServiceSelectorFactory createMergingServiceSelectorFactory(SimpleServiceSelectorFactory factory, Announcer announcer, NodeInfo nodeInfo) {
        return new MergingServiceSelectorFactory(factory, announcer, nodeInfo);
    }
}

