/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ml;

import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.plugin.ml.EvaluateClassifierPredictionsState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.GroupedAccumulatorState;
import java.util.HashMap;
import java.util.Map;

public class EvaluateClassifierPredictionsStateFactory
implements AccumulatorStateFactory<EvaluateClassifierPredictionsState> {
    private static final long HASH_MAP_SIZE = SizeOf.instanceSize(HashMap.class);

    public EvaluateClassifierPredictionsState createSingleState() {
        return new SingleEvaluateClassifierPredictionsState();
    }

    public EvaluateClassifierPredictionsState createGroupedState() {
        return new GroupedEvaluateClassifierPredictionsState();
    }

    public static class SingleEvaluateClassifierPredictionsState
    implements EvaluateClassifierPredictionsState {
        private final Map<String, Integer> truePositives = new HashMap<String, Integer>();
        private final Map<String, Integer> falsePositives = new HashMap<String, Integer>();
        private final Map<String, Integer> falseNegatives = new HashMap<String, Integer>();
        private int memoryUsage;

        public long getEstimatedSize() {
            return (long)this.memoryUsage + 3L * HASH_MAP_SIZE;
        }

        @Override
        public void addMemoryUsage(int memory) {
            this.memoryUsage += memory;
        }

        @Override
        public Map<String, Integer> getTruePositives() {
            return this.truePositives;
        }

        @Override
        public Map<String, Integer> getFalsePositives() {
            return this.falsePositives;
        }

        @Override
        public Map<String, Integer> getFalseNegatives() {
            return this.falseNegatives;
        }
    }

    public static class GroupedEvaluateClassifierPredictionsState
    implements GroupedAccumulatorState,
    EvaluateClassifierPredictionsState {
        private final ObjectBigArray<Map<String, Integer>> truePositives = new ObjectBigArray();
        private final ObjectBigArray<Map<String, Integer>> falsePositives = new ObjectBigArray();
        private final ObjectBigArray<Map<String, Integer>> falseNegatives = new ObjectBigArray();
        private long groupId;
        private long memoryUsage;

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        @Override
        public void addMemoryUsage(int memory) {
            this.memoryUsage += (long)memory;
        }

        @Override
        public Map<String, Integer> getTruePositives() {
            if (this.truePositives.get(this.groupId) == null) {
                this.truePositives.set(this.groupId, new HashMap());
                this.memoryUsage += HASH_MAP_SIZE;
            }
            return (Map)this.truePositives.get(this.groupId);
        }

        @Override
        public Map<String, Integer> getFalsePositives() {
            if (this.falsePositives.get(this.groupId) == null) {
                this.falsePositives.set(this.groupId, new HashMap());
                this.memoryUsage += HASH_MAP_SIZE;
            }
            return (Map)this.falsePositives.get(this.groupId);
        }

        @Override
        public Map<String, Integer> getFalseNegatives() {
            if (this.falseNegatives.get(this.groupId) == null) {
                this.falseNegatives.set(this.groupId, new HashMap());
                this.memoryUsage += HASH_MAP_SIZE;
            }
            return (Map)this.falseNegatives.get(this.groupId);
        }

        public void ensureCapacity(long size) {
            this.truePositives.ensureCapacity(size);
            this.falsePositives.ensureCapacity(size);
            this.falseNegatives.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return this.memoryUsage + this.truePositives.sizeOf() + this.falsePositives.sizeOf() + this.falseNegatives.sizeOf();
        }
    }
}

