/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedBlockChecksumReconstructor;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.util.CrcComposer;

@InterfaceAudience.Private
public class StripedBlockChecksumCompositeCrcReconstructor
extends StripedBlockChecksumReconstructor {
    private final int ecPolicyCellSize;
    private byte[] digestValue;
    private CrcComposer digester;

    public StripedBlockChecksumCompositeCrcReconstructor(ErasureCodingWorker worker, StripedReconstructionInfo stripedReconInfo, DataOutputBuffer checksumWriter, long requestedBlockLength) throws IOException {
        super(worker, stripedReconInfo, checksumWriter, requestedBlockLength);
        this.ecPolicyCellSize = stripedReconInfo.getEcPolicy().getCellSize();
    }

    @Override
    public Object getDigestObject() {
        return this.digestValue;
    }

    @Override
    void prepareDigester() throws IOException {
        this.digester = CrcComposer.newStripedCrcComposer(this.getChecksum().getChecksumType(), this.getChecksum().getBytesPerChecksum(), this.ecPolicyCellSize);
    }

    @Override
    void updateDigester(byte[] checksumBytes, int dataBytesPerChecksum) throws IOException {
        if (this.digester == null) {
            throw new IOException(String.format("Called updatedDigester with checksumBytes.length=%d, dataBytesPerChecksum=%d but digester is null", checksumBytes.length, dataBytesPerChecksum));
        }
        this.digester.update(checksumBytes, 0, checksumBytes.length, dataBytesPerChecksum);
    }

    @Override
    void commitDigest() throws IOException {
        if (this.digester == null) {
            throw new IOException("Called commitDigest() but digester is null");
        }
        this.digestValue = this.digester.digest();
        this.getChecksumWriter().write(this.digestValue, 0, this.digestValue.length);
    }
}

