/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigHidden;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"bigquery.case-insensitive-name-matching.cache-ttl"})
public class BigQueryConfig {
    private static final int MAX_RPC_CONNECTIONS = 1024;
    public static final int DEFAULT_MAX_READ_ROWS_RETRIES = 3;
    public static final String VIEWS_ENABLED = "bigquery.views-enabled";
    public static final String EXPERIMENTAL_ARROW_SERIALIZATION_ENABLED = "bigquery.experimental.arrow-serialization.enabled";
    private Optional<String> projectId = Optional.empty();
    private Optional<String> parentProjectId = Optional.empty();
    private Optional<Integer> parallelism = Optional.empty();
    private boolean viewsEnabled;
    private boolean arrowSerializationEnabled;
    private Duration viewExpireDuration = new Duration(24.0, TimeUnit.HOURS);
    private boolean skipViewMaterialization;
    private Optional<String> viewMaterializationProject = Optional.empty();
    private Optional<String> viewMaterializationDataset = Optional.empty();
    private int maxReadRowsRetries = 3;
    private boolean caseInsensitiveNameMatching;
    private Duration viewsCacheTtl = new Duration(15.0, TimeUnit.MINUTES);
    private Duration serviceCacheTtl = new Duration(3.0, TimeUnit.MINUTES);
    private Duration metadataCacheTtl = new Duration(0.0, TimeUnit.MILLISECONDS);
    private boolean queryResultsCacheEnabled;
    private int rpcInitialChannelCount = 1;
    private int rpcMinChannelCount = 1;
    private int rpcMaxChannelCount = 1;
    private int minRpcPerChannel;
    private int maxRpcPerChannel = Integer.MAX_VALUE;

    public Optional<String> getProjectId() {
        return this.projectId;
    }

    @Config(value="bigquery.project-id")
    @ConfigDescription(value="The Google Cloud Project ID where the data reside")
    public BigQueryConfig setProjectId(String projectId) {
        this.projectId = Optional.ofNullable(projectId);
        return this;
    }

    public Optional<String> getParentProjectId() {
        return this.parentProjectId;
    }

    @Config(value="bigquery.parent-project-id")
    @ConfigDescription(value="The Google Cloud Project ID to bill for the export")
    public BigQueryConfig setParentProjectId(String parentProjectId) {
        this.parentProjectId = Optional.ofNullable(parentProjectId);
        return this;
    }

    public Optional<Integer> getParallelism() {
        return this.parallelism;
    }

    @Config(value="bigquery.parallelism")
    @ConfigDescription(value="The number of partitions to split the data into.")
    public BigQueryConfig setParallelism(Integer parallelism) {
        this.parallelism = Optional.ofNullable(parallelism);
        return this;
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Config(value="bigquery.views-enabled")
    @ConfigDescription(value="Enables the connector to read from views and not only tables")
    public BigQueryConfig setViewsEnabled(boolean viewsEnabled) {
        this.viewsEnabled = viewsEnabled;
        return this;
    }

    public boolean isArrowSerializationEnabled() {
        return this.arrowSerializationEnabled;
    }

    @Config(value="bigquery.experimental.arrow-serialization.enabled")
    @ConfigDescription(value="Enables experimental Arrow serialization while reading data")
    public BigQueryConfig setArrowSerializationEnabled(boolean arrowSerializationEnabled) {
        this.arrowSerializationEnabled = arrowSerializationEnabled;
        return this;
    }

    @NotNull
    public Duration getViewExpireDuration() {
        return this.viewExpireDuration;
    }

    @Config(value="bigquery.view-expire-duration")
    public BigQueryConfig setViewExpireDuration(Duration viewExpireDuration) {
        this.viewExpireDuration = viewExpireDuration;
        return this;
    }

    public boolean isSkipViewMaterialization() {
        return this.skipViewMaterialization;
    }

    @Config(value="bigquery.skip-view-materialization")
    @ConfigDescription(value="Skip materializing views")
    public BigQueryConfig setSkipViewMaterialization(boolean skipViewMaterialization) {
        this.skipViewMaterialization = skipViewMaterialization;
        return this;
    }

    public Optional<String> getViewMaterializationProject() {
        return this.viewMaterializationProject;
    }

    @Config(value="bigquery.view-materialization-project")
    @ConfigDescription(value="The project where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationProject(String viewMaterializationProject) {
        this.viewMaterializationProject = Optional.ofNullable(viewMaterializationProject);
        return this;
    }

    public Optional<String> getViewMaterializationDataset() {
        return this.viewMaterializationDataset;
    }

    @Config(value="bigquery.view-materialization-dataset")
    @ConfigDescription(value="The dataset where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationDataset(String viewMaterializationDataset) {
        this.viewMaterializationDataset = Optional.ofNullable(viewMaterializationDataset);
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    @Config(value="bigquery.max-read-rows-retries")
    @ConfigDescription(value="The number of retries in case of retryable server issues")
    public BigQueryConfig setMaxReadRowsRetries(int maxReadRowsRetries) {
        this.maxReadRowsRetries = maxReadRowsRetries;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="bigquery.case-insensitive-name-matching")
    @ConfigDescription(value="Match dataset and table names case-insensitively")
    public BigQueryConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0m")
    public @NotNull @MinDuration(value="0m") Duration getViewsCacheTtl() {
        return this.viewsCacheTtl;
    }

    @Config(value="bigquery.views-cache-ttl")
    @ConfigDescription(value="Duration for which the materialization of a view will be cached and reused")
    public BigQueryConfig setViewsCacheTtl(Duration viewsCacheTtl) {
        this.viewsCacheTtl = viewsCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="0m")
    public @NotNull @MinDuration(value="0m") Duration getServiceCacheTtl() {
        return this.serviceCacheTtl;
    }

    @ConfigHidden
    @Config(value="bigquery.service-cache-ttl")
    @ConfigDescription(value="Duration for which BigQuery client service instances are cached")
    public BigQueryConfig setServiceCacheTtl(Duration serviceCacheTtl) {
        this.serviceCacheTtl = serviceCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="bigquery.metadata.cache-ttl")
    @ConfigDescription(value="Duration for which BigQuery client metadata is cached after listing")
    public BigQueryConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    public boolean isQueryResultsCacheEnabled() {
        return this.queryResultsCacheEnabled;
    }

    @Config(value="bigquery.query-results-cache.enabled")
    public BigQueryConfig setQueryResultsCacheEnabled(boolean queryResultsCacheEnabled) {
        this.queryResultsCacheEnabled = queryResultsCacheEnabled;
        return this;
    }

    @Min(value=1L)
    @Max(value=1024L)
    public @Min(value=1L) @Max(value=1024L) int getRpcInitialChannelCount() {
        return this.rpcInitialChannelCount;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.initial-size")
    public BigQueryConfig setRpcInitialChannelCount(int rpcInitialChannelCount) {
        this.rpcInitialChannelCount = rpcInitialChannelCount;
        return this;
    }

    @Min(value=1L)
    @Max(value=1024L)
    public @Min(value=1L) @Max(value=1024L) int getRpcMinChannelCount() {
        return this.rpcMinChannelCount;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.min-size")
    public BigQueryConfig setRpcMinChannelCount(int rpcMinChannelCount) {
        this.rpcMinChannelCount = rpcMinChannelCount;
        return this;
    }

    @Min(value=1L)
    @Max(value=1024L)
    public @Min(value=1L) @Max(value=1024L) int getRpcMaxChannelCount() {
        return this.rpcMaxChannelCount;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.max-size")
    public BigQueryConfig setRpcMaxChannelCount(int rpcMaxChannelCount) {
        this.rpcMaxChannelCount = rpcMaxChannelCount;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMinRpcPerChannel() {
        return this.minRpcPerChannel;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.min-rpc-per-channel")
    public BigQueryConfig setMinRpcPerChannel(int minRpcPerChannel) {
        this.minRpcPerChannel = minRpcPerChannel;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxRpcPerChannel() {
        return this.maxRpcPerChannel;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.max-rpc-per-channel")
    public BigQueryConfig setMaxRpcPerChannel(int maxRpcPerChannel) {
        this.maxRpcPerChannel = maxRpcPerChannel;
        return this;
    }

    @PostConstruct
    public void validate() {
        Preconditions.checkState((this.viewExpireDuration.toMillis() > this.viewsCacheTtl.toMillis() ? 1 : 0) != 0, (Object)"View expiration duration must be longer than view cache TTL");
        if (this.skipViewMaterialization) {
            Preconditions.checkState((boolean)this.viewsEnabled, (String)"%s config property must be enabled when skipping view materialization", (Object)VIEWS_ENABLED);
        }
    }
}

