/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.CommonUtilities;
import com.qubole.rubix.spi.DataTransferClientHelper;
import com.qubole.rubix.spi.DataTransferHeader;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.CacheStatusResponse;
import com.qubole.rubix.spi.thrift.Location;
import com.qubole.rubix.spi.thrift.ReadResponse;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.thrift.shaded.TException;

public class LocalDataTransferServer
extends Configured
implements Tool {
    private static Log log = LogFactory.getLog((String)LocalDataTransferServer.class.getName());
    private static Configuration conf;
    private static LocalServer localServer;
    private static MetricRegistry metrics;
    private static BookKeeperMetrics bookKeeperMetrics;
    private static Counter cachingExceptionCounter;

    private LocalDataTransferServer() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new LocalDataTransferServer(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        conf = this.getConf();
        LocalDataTransferServer.startServer(conf, new MetricRegistry());
        return 0;
    }

    public static void startServer(Configuration conf, MetricRegistry metricRegistry) {
        LocalDataTransferServer.startServer(conf, metricRegistry, null);
    }

    public static void startServer(Configuration conf, MetricRegistry metricRegistry, BookKeeper bookKeeper) {
        conf = new Configuration(ClusterUtil.applyRubixSiteConfig(conf));
        CacheConfig.setCacheDataEnabled(conf, false);
        metrics = metricRegistry;
        LocalDataTransferServer.registerMetrics(conf);
        localServer = new LocalServer(conf, bookKeeper);
        new Thread(localServer).start();
    }

    private static void registerMetrics(Configuration conf) {
        bookKeeperMetrics = new BookKeeperMetrics(conf, metrics);
        metrics.register(BookKeeperMetrics.LDTSJvmMetric.LDTS_JVM_GC_PREFIX.getMetricName(), new GarbageCollectorMetricSet());
        metrics.register(BookKeeperMetrics.LDTSJvmMetric.LDTS_JVM_THREADS_PREFIX.getMetricName(), new CachedThreadStatesGaugeSet(CacheConfig.getMetricsReportingInterval(conf), TimeUnit.MILLISECONDS));
        metrics.register(BookKeeperMetrics.LDTSJvmMetric.LDTS_JVM_MEMORY_PREFIX.getMetricName(), new MemoryUsageGaugeSet());
        cachingExceptionCounter = metrics.counter(BookKeeperMetrics.CacheMetric.LDTS_CACHING_EXCEPTION.getMetricName());
    }

    public static void stopServer() {
        if (!LocalDataTransferServer.isServerUp()) {
            return;
        }
        LocalDataTransferServer.removeMetrics();
        if (localServer != null) {
            try {
                bookKeeperMetrics.close();
            }
            catch (IOException e) {
                log.error((Object)"Metrics reporters could not be closed", (Throwable)e);
            }
            localServer.stop();
        }
    }

    protected static void removeMetrics() {
        metrics.removeMatching(bookKeeperMetrics.getMetricsFilter());
    }

    @VisibleForTesting
    public static boolean isServerUp() {
        if (localServer != null) {
            return localServer.isAlive();
        }
        return false;
    }

    static class ClientServiceThread
    extends Thread {
        SocketChannel localDataTransferClient;
        Configuration conf;
        BookKeeperFactory bookKeeperFactory;

        ClientServiceThread(SocketChannel s, Configuration conf, BookKeeperFactory bookKeeperFactory) {
            this.localDataTransferClient = s;
            this.conf = conf;
            this.bookKeeperFactory = bookKeeperFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                log.debug((Object)("Connected to node - Local Address: " + this.localDataTransferClient.getLocalAddress() + " Remote Address: " + this.localDataTransferClient.getRemoteAddress()));
                while (this.localDataTransferClient.isConnected()) {
                    ByteBuffer dataInfo = ByteBuffer.allocate(CacheConfig.getMaxHeaderSize(this.conf));
                    try {
                        int read = this.localDataTransferClient.read(dataInfo);
                        if (read == -1) {
                            throw new IOException("Could not read data from Non-local node");
                        }
                    }
                    catch (IOException e) {
                        break;
                    }
                    dataInfo.flip();
                    DataTransferHeader header = DataTransferClientHelper.readHeaders(dataInfo);
                    long offset = header.getOffset();
                    int readLength = header.getReadLength();
                    String remotePath = header.getFilePath();
                    log.debug((Object)String.format("Trying to read from %s at offset %d and length %d for client %s", remotePath, offset, readLength, this.localDataTransferClient.getRemoteAddress()));
                    int generationNumber = 0;
                    RetryingPooledBookkeeperClient bookKeeperClient = this.bookKeeperFactory.createBookKeeperClient(this.conf);
                    Throwable throwable = null;
                    try {
                        if (!CacheConfig.isParallelWarmupEnabled(this.conf)) {
                            ReadResponse response = bookKeeperClient.readData(remotePath, offset, readLength, header.getFileSize(), header.getLastModified(), header.getClusterType());
                            generationNumber = response.getGenerationNumber();
                            if (!response.isStatus()) {
                                throw new Exception("Could not cache data required by non-local node");
                            }
                        } else {
                            long blockSize = CacheConfig.getBlockSize(this.conf);
                            long startBlock = offset / blockSize;
                            long endBlock = (offset + (long)(readLength - 1)) / blockSize + 1L;
                            CacheStatusRequest request = new CacheStatusRequest(remotePath, header.getFileSize(), header.getLastModified(), startBlock, endBlock).setClusterType(header.getClusterType());
                            CacheStatusResponse response = bookKeeperClient.getCacheStatus(request);
                            List<BlockLocation> blockLocations = response.getBlocks();
                            generationNumber = response.getGenerationNumber();
                            long blockNum = startBlock;
                            for (BlockLocation location : blockLocations) {
                                if (location.getLocation() != Location.CACHED) {
                                    log.warn((Object)String.format("The requested data for block %d of file %s is not in cache.  The data will be read from object store. Status: %s %s", blockNum, remotePath, location.getLocation(), location.getRemoteLocation()));
                                    throw new Exception("The requested data in not in cache. The data will be read from object store");
                                }
                                ++blockNum;
                            }
                        }
                        int nread = this.readDataFromCachedFile(bookKeeperClient, remotePath, generationNumber, offset, readLength);
                        log.debug((Object)String.format("Done reading %d from %s at offset %d and length %d for client %s", nread, remotePath, offset, readLength, this.localDataTransferClient.getRemoteAddress()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bookKeeperClient == null) continue;
                        if (throwable != null) {
                            try {
                                bookKeeperClient.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bookKeeperClient.close();
                    }
                }
            }
            catch (Exception e) {
                try {
                    log.warn((Object)("Error in Local Data Transfer Server for client: " + this.localDataTransferClient.getRemoteAddress()), (Throwable)e);
                    cachingExceptionCounter.inc();
                }
                catch (IOException e1) {
                    log.warn((Object)"Error in Local Data Transfer Server for client: ", (Throwable)e);
                }
                return;
            }
            finally {
                try {
                    this.localDataTransferClient.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Error in Local Data Transfer Server: ", (Throwable)e);
                }
            }
        }

        private int readDataFromCachedFile(RetryingPooledBookkeeperClient bookKeeperClient, String remotePath, int generationNumber, long offset, int readLength) throws IOException, TException {
            FileChannel fc = null;
            int nread = 0;
            String filename = CacheUtil.getLocalPath(remotePath, this.conf, generationNumber);
            try {
                fc = new FileInputStream(filename).getChannel();
                int maxCount = CacheConfig.getDataTransferBufferSize(this.conf);
                int lengthRemaining = readLength;
                long position = offset;
                if (fc.size() < (long)readLength) {
                    log.error((Object)String.format("File size is smaller than requested read. Invalidating corrupted cached file %s", remotePath));
                    bookKeeperClient.invalidateFileMetadata(remotePath);
                    throw new IOException("File size is smaller than requested read");
                }
                while (nread < readLength) {
                    if (maxCount > lengthRemaining) {
                        maxCount = lengthRemaining;
                    }
                    nread = (int)((long)nread + fc.transferTo(position + (long)nread, maxCount, this.localDataTransferClient));
                    lengthRemaining = readLength - nread;
                }
            }
            catch (FileNotFoundException ex) {
                log.error((Object)String.format("Could not create file channel for %s. Invalidating missing remote file %s", filename, remotePath));
                bookKeeperClient.invalidateFileMetadata(remotePath);
                throw new IOException(String.format("File not found %s ", filename), ex);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            finally {
                if (fc != null) {
                    fc.close();
                }
            }
            return nread;
        }
    }

    public static class LocalServer
    implements Runnable {
        static ServerSocketChannel listener;
        Configuration conf;
        BookKeeperFactory bookKeeperFactory;

        public LocalServer(Configuration conf, BookKeeper bookKeeper) {
            this(conf, new BookKeeperFactory(bookKeeper));
        }

        public LocalServer(Configuration conf, BookKeeperFactory bookKeeperFactory) {
            this.conf = conf;
            this.bookKeeperFactory = bookKeeperFactory;
            int port = CacheConfig.getDataTransferServerPort(conf);
            log.debug((Object)("Starting LocalDataTransferServer on port " + port));
            try {
                listener = ServerSocketChannel.open();
                listener.bind(new InetSocketAddress(port), Integer.MAX_VALUE);
            }
            catch (IOException e) {
                throw new RuntimeException("Error starting Local Transfer server", e);
            }
        }

        @Override
        public void run() {
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, CacheConfig.getLocalTransferServerMaxThreads(this.conf), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), CommonUtilities.threadsNamed("lds-worker-%s"));
            try {
                while (true) {
                    SocketChannel clientSocket = listener.accept();
                    ClientServiceThread cliThread = new ClientServiceThread(clientSocket, this.conf, this.bookKeeperFactory);
                    threadPool.execute(cliThread);
                }
            }
            catch (AsynchronousCloseException e) {
                log.warn((Object)"Stopping Local Transfer server", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error accepting Local Transfer connection", (Throwable)e);
            }
        }

        public boolean isAlive() {
            return listener.isOpen();
        }

        public void stop() {
            try {
                listener.close();
            }
            catch (IOException e) {
                log.error((Object)"Error stopping Local Transfer server", (Throwable)e);
            }
        }
    }
}

